/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.ignore.lang.GitExcludeFileType;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExcludeLanguage
extends IgnoreLanguage {
    public static final GitExcludeLanguage INSTANCE = new GitExcludeLanguage();

    private GitExcludeLanguage() {
        super("GitExclude", "exclude");
    }

    @NotNull
    public String getFilename() {
        return super.getExtension();
    }

    @NotNull
    public IgnoreFileType getFileType() {
        return GitExcludeFileType.INSTANCE;
    }

    @Nullable
    public VirtualFile getAffectedRoot(@NotNull Project project, @NotNull VirtualFile ignoreFile) {
        GitRepository repository = GitExcludeLanguage.findRepository(project, ignoreFile);
        if (repository == null) {
            return null;
        }
        return repository.getRoot();
    }

    @Nullable
    private static GitRepository findRepository(@NotNull Project project, @NotNull VirtualFile excludeFile) {
        String excludeFilePath = excludeFile.getPath();
        for (GitRepository repository : GitRepositoryManager.getInstance(project).getRepositories()) {
            if (!repository.getRepositoryFiles().isExclude(excludeFilePath)) continue;
            return repository;
        }
        return null;
    }
}

