/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import git4idea.history.GitCompressedRecord;
import git4idea.history.GitLogRecordCollector;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GitLogUnorderedRecordCollector
extends GitLogRecordCollector<GitCompressedRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogUnorderedRecordCollector.class);
    private static final int STATUS_LINES_THRESHOLD = 200000;
    @NotNull
    private final MultiMap<String, GitCompressedRecord> myHashToIncompleteRecords = MultiMap.createLinked();
    private int myIncompleteStatusLinesCount = 0;

    protected GitLogUnorderedRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super List<GitCompressedRecord>> consumer2) {
        super(project, root, consumer2);
    }

    @Override
    protected void processCollectedRecords() {
        this.processCollectedRecords(false);
    }

    private void processCollectedRecords(boolean processIncompleteRecords) {
        super.processCollectedRecords();
        if (!this.myHashToIncompleteRecords.isEmpty() && (processIncompleteRecords || this.myIncompleteStatusLinesCount >= 200000)) {
            try {
                this.processIncompleteRecords(this.myHashToIncompleteRecords, this.myProject, this.myRoot, this.myConsumer);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myHashToIncompleteRecords.clear();
                this.myIncompleteStatusLinesCount = 0;
            }
        }
    }

    @Override
    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<GitCompressedRecord> records) {
        this.myHashToIncompleteRecords.put((Object)hash, records);
        records.forEach(r -> this.myIncompleteStatusLinesCount += r.getChanges().size() + r.getRenames().size());
    }

    @Override
    protected GitCompressedRecord createEmptyCopy(@NotNull GitCompressedRecord record) {
        return new GitCompressedRecord(record.getOptions(), (TIntObjectHashMap<Change.Type>)new TIntObjectHashMap(), new TIntIntHashMap(), record.isSupportsRawBody());
    }

    @Override
    public void finish() {
        this.processCollectedRecords(true);
    }
}

