/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.GitLogParser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/history/GitLogHistoryHandler;", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRename", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler$Rename;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "beforeHash", "Lcom/intellij/vcs/log/Hash;", "afterHash", "RenamesCollector", "intellij.vcs.git"})
public final class GitLogHistoryHandler
implements VcsLogFileHistoryHandler {
    private final Logger LOG;
    private final Project project;

    @Nullable
    public VcsLogFileHistoryHandler.Rename getRename(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash beforeHash, @NotNull Hash afterHash) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(this.project, root, GitCommand.DIFF);
        h2.setWithMediator(false);
        h2.setStdoutSuppressed(true);
        h2.addParameters("-M", "--diff-filter=R", "--name-status", "--encoding=UTF-8", "--follow", beforeHash.asString() + ".." + afterHash.asString());
        h2.endOptions();
        h2.addRelativePaths(filePath);
        RenamesCollector renamesCollector = new RenamesCollector(h2.printableCommandLine());
        h2.addLineListener(renamesCollector.getLineListener());
        Git.getInstance().runCommandWithoutCollectingOutput(h2).throwOnError(new int[0]);
        VcsFileStatusInfo vcsFileStatusInfo = renamesCollector.getSingleRename();
        if (vcsFileStatusInfo != null) {
            VcsFileStatusInfo vcsFileStatusInfo2 = vcsFileStatusInfo;
            boolean bl = false;
            boolean bl2 = false;
            VcsFileStatusInfo info = vcsFileStatusInfo2;
            boolean bl3 = false;
            FilePath firstPath = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getFirstPath()), (boolean)false);
            FilePath secondPath = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getSecondPath()), (boolean)false);
            return new VcsLogFileHistoryHandler.Rename(firstPath, secondPath, beforeHash, afterHash);
        }
        return null;
    }

    public GitLogHistoryHandler(@NotNull Project project) {
        this.project = project;
        this.LOG = Logger.getInstance(GitLogHistoryHandler.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/history/GitLogHistoryHandler$RenamesCollector;", "Lgit4idea/history/DefaultGitLogFullRecordBuilder;", "commandLine", "", "(Lgit4idea/history/GitLogHistoryHandler;Ljava/lang/String;)V", "unexpectedStatusReported", "", "addPath", "", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "firstPath", "secondPath", "getLineListener", "Lgit4idea/commands/GitLineHandlerListener;", "getSingleRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "intellij.vcs.git"})
    private final class RenamesCollector
    extends DefaultGitLogFullRecordBuilder {
        private boolean unexpectedStatusReported;
        private final String commandLine;

        @Override
        public void addPath(@NotNull Change.Type type, @NotNull String firstPath, @Nullable String secondPath) {
            if (type == Change.Type.MOVED) {
                super.addPath(type, firstPath, secondPath);
            } else if (!this.unexpectedStatusReported) {
                this.unexpectedStatusReported = true;
                GitLogHistoryHandler.this.LOG.error("Unexpected change " + type + ' ' + firstPath + ' ' + secondPath + " in the output of [" + this.commandLine + ']');
            }
        }

        @NotNull
        public final GitLineHandlerListener getLineListener() {
            GitLogParser.PathsParser parser = new GitLogParser.PathsParser(GitLogParser.NameStatus.STATUS, this);
            return new GitLineHandlerListener(parser){
                final /* synthetic */ GitLogParser.PathsParser $parser;

                public final void onLineAvailable(String line, Key<Object> outputType) {
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                        this.$parser.parseLine(line);
                    }
                }
                {
                    this.$parser = pathsParser;
                }
            };
        }

        @Nullable
        public final VcsFileStatusInfo getSingleRename() {
            VcsFileStatusInfo info;
            if (this.getStatuses$intellij_vcs_git().size() > 1) {
                GitLogHistoryHandler.this.LOG.error("Unexpected multiple renames found. Command [" + this.commandLine + "].\n" + "Output [" + this.getStatuses$intellij_vcs_git() + "].");
            }
            VcsFileStatusInfo vcsFileStatusInfo = info = (VcsFileStatusInfo)CollectionsKt.singleOrNull(this.getStatuses$intellij_vcs_git());
            if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getSecondPath() : null) != null) {
                return info;
            }
            return null;
        }

        public RenamesCollector(String commandLine) {
            this.commandLine = commandLine;
        }
    }
}

