/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeHandler {
    private static final Logger LOG = Logger.getInstance(GitMergeHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergeDialogCustomizer myDialogCustomizer;

    public GitMergeHandler(@NotNull Project project, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        this.myProject = project;
        this.myDialogCustomizer = mergeDialogCustomizer;
    }

    @NotNull
    public String loadMergeDescription() {
        return this.myDialogCustomizer.getMultipleFileMergeDescription(Collections.emptyList());
    }

    public boolean canResolveConflict(@NotNull GitConflict conflict) {
        VirtualFile file = conflict.getFilePath().getVirtualFile();
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return conflict.getStatus(GitConflict.ConflictSide.OURS) != GitConflict.Status.DELETED || conflict.getStatus(GitConflict.ConflictSide.THEIRS) != GitConflict.Status.DELETED;
    }

    @NotNull
    public Resolver resolveConflict(@NotNull GitConflict conflict, @NotNull VirtualFile file, boolean isReversed) throws VcsException {
        VirtualFile root = conflict.getRoot();
        FilePath path = conflict.getFilePath();
        MergeData mergeData = GitMergeUtil.loadMergeData(this.myProject, root, path, isReversed);
        String windowTitle = this.myDialogCustomizer.getMergeWindowTitle(file);
        String leftTitle = this.myDialogCustomizer.getLeftPanelTitle(file);
        String centerTitle = this.myDialogCustomizer.getCenterPanelTitle(file);
        String rightTitle = this.myDialogCustomizer.getRightPanelTitle(file, mergeData.LAST_REVISION_NUMBER);
        MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList = this.myDialogCustomizer.getTitleCustomizerList(path);
        return new Resolver(this.myProject, conflict, isReversed, file, mergeData, windowTitle, Arrays.asList(leftTitle, centerTitle, rightTitle), titleCustomizerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptOneVersion(@NotNull Collection<? extends GitConflict> conflicts, @NotNull Collection<? extends VirtualFile> reversedRoots, boolean takeTheirs) throws VcsException {
        try {
            MultiMap<VirtualFile, GitConflict> byRoot = GitMergeHandler.groupConflictsByRoot(conflicts);
            for (VirtualFile root : byRoot.keySet()) {
                Collection rootConflicts = byRoot.get((Object)root);
                boolean isReversed = reversedRoots.contains(root);
                GitConflict.ConflictSide side = isReversed == takeTheirs ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                GitMergeUtil.acceptOneVersion(this.myProject, root, rootConflicts, side);
                GitMergeUtil.markConflictResolved(this.myProject, root, rootConflicts, side);
            }
        }
        finally {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty((Collection)ContainerUtil.map(conflicts, GitConflict::getFilePath), null);
        }
    }

    @NotNull
    public static MultiMap<VirtualFile, GitConflict> groupConflictsByRoot(@NotNull Collection<? extends GitConflict> conflicts) {
        MultiMap byRoot = MultiMap.create();
        for (GitConflict gitConflict : conflicts) {
            byRoot.putValue((Object)gitConflict.getRoot(), (Object)gitConflict);
        }
        return byRoot;
    }

    public static class Resolver {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitConflict myConflict;
        private final boolean myIsReversed;
        @NotNull
        private final MergeData myMergeData;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final String myWindowTitle;
        @NotNull
        private final List<String> myContentTitles;
        @NotNull
        private final MergeDialogCustomizer.DiffEditorTitleCustomizerList myTitleCustomizerList;
        private volatile boolean myIsValid = true;

        private Resolver(@NotNull Project project, @NotNull GitConflict conflict, boolean isReversed, @NotNull VirtualFile file, @NotNull MergeData mergeData, @NotNull String windowTitle, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList) {
            this.myProject = project;
            this.myConflict = conflict;
            this.myIsReversed = isReversed;
            this.myMergeData = mergeData;
            this.myFile = file;
            this.myWindowTitle = windowTitle;
            this.myContentTitles = contentTitles;
            this.myTitleCustomizerList = titleCustomizerList;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @NotNull
        public MergeData getMergeData() {
            return this.myMergeData;
        }

        public void onConflictResolved(@NotNull MergeResult result2) {
            if (result2 != MergeResult.CANCEL) {
                try {
                    GitMergeUtil.markConflictResolved(this.myProject, this.myConflict.getRoot(), Collections.singletonList(this.myConflict), this.getResolutionSide(result2));
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation: file - %s)", this.myConflict.getFilePath()), (Throwable)e);
                }
            }
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(Collections.singletonList(this.myFile), Collections.emptyList());
        }

        @Nullable
        private GitConflict.ConflictSide getResolutionSide(@NotNull MergeResult result2) {
            switch (result2) {
                case LEFT: {
                    return !this.myIsReversed ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                }
                case RIGHT: {
                    return this.myIsReversed ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                }
            }
            return null;
        }

        @NotNull
        public String getWindowTitle() {
            return this.myWindowTitle;
        }

        @NotNull
        public List<String> getContentTitles() {
            return this.myContentTitles;
        }

        @NotNull
        public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList() {
            return this.myTitleCustomizerList;
        }

        public boolean checkIsValid() {
            if (this.myIsValid) {
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRootQuick(this.myConflict.getRoot());
                if (repository == null) {
                    return true;
                }
                this.myIsValid = repository.getStagingAreaHolder().findConflict(this.myConflict.getFilePath()) != null;
            }
            return this.myIsValid;
        }

        public void addListener(@NotNull MergeCallback.Listener listener, @NotNull Disposable disposable) {
            this.myProject.getMessageBus().connect(disposable).subscribe(GitStagingAreaHolder.TOPIC, repo -> {
                if (this.myIsValid && this.myConflict.getRoot().equals(repo.getRoot()) && !this.checkIsValid()) {
                    listener.fireConflictInvalid();
                }
            });
        }
    }
}

