/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitUtil;
import git4idea.conflicts.GitConflictsPanel;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MergeConflictResolveUtil;
import git4idea.conflicts.MyChangesTree;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.status.GitStagingAreaHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002J\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020\u001eH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/conflicts/GitConflictsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/conflicts/GitMergeHandler;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "conflicts", "", "Lgit4idea/repo/GitConflict;", "conflictsTree", "Lgit4idea/conflicts/MyChangesTree;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/conflicts/GitConflictsPanel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "panel", "preferredFocusableComponent", "getPreferredFocusableComponent", "reversedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "acceptConflictSideForSelection", "", "takeTheirs", "", "addListener", "listener", "canAcceptConflictSideForSelection", "canShowMergeWindowForSelection", "dispose", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "conflict", "getSelectedConflicts", "", "showMergeWindowForSelection", "updateConflicts", "Listener", "MainPanel", "intellij.vcs.git"})
public final class GitConflictsPanel
implements Disposable {
    private final JComponent panel;
    private final MyChangesTree conflictsTree;
    private final List<GitConflict> conflicts;
    private final Set<VirtualFile> reversedRoots;
    private final MergingUpdateQueue updateQueue;
    private final EventDispatcher<Listener> eventDispatcher;
    private final Project project;
    private final GitMergeHandler mergeHandler;

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return (JComponent)((Object)this.conflictsTree);
    }

    public void dispose() {
    }

    public final void addListener(@NotNull Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    private final List<GitConflict> getSelectedConflicts() {
        return this.conflictsTree.getSelectedChanges();
    }

    private final void updateConflicts() {
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", (Runnable)new Runnable(this){
            final /* synthetic */ GitConflictsPanel this$0;

            public final void run() {
                String description = GitConflictsPanel.access$getMergeHandler$p(this.this$0).loadMergeDescription();
                ArrayList<E> newConflicts = new ArrayList<E>();
                ArrayList<VirtualFile> newReversedRoots = new ArrayList<VirtualFile>();
                Collection<GitRepository> repos = GitUtil.getRepositories(GitConflictsPanel.access$getProject$p(this.this$0));
                for (GitRepository repo : repos) {
                    if (GitMergeUtil.isReverseRoot(repo)) {
                        newReversedRoots.add(repo.getRoot());
                    }
                    newConflicts.addAll(repo.getStagingAreaHolder().getAllConflicts());
                }
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl = false;
                    ((Listener)GitConflictsPanel.access$getEventDispatcher$p(this.this$0).getMulticaster()).onDescriptionChange(description);
                    GitConflictsPanel.access$getConflicts$p(this.this$0).clear();
                    GitConflictsPanel.access$getConflicts$p(this.this$0).addAll((Collection)newConflicts);
                    GitConflictsPanel.access$getReversedRoots$p(this.this$0).clear();
                    GitConflictsPanel.access$getReversedRoots$p(this.this$0).addAll((Collection)newReversedRoots);
                    GitConflictsPanel.access$getConflictsTree$p(this.this$0).setChangesToDisplay(GitConflictsPanel.access$getConflicts$p(this.this$0));
                    if (GitConflictsPanel.access$getConflictsTree$p(this.this$0).getSelectionCount() == 0) {
                        TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)GitConflictsPanel.access$getConflictsTree$p(this.this$0))));
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, description, newConflicts, newReversedRoots){
                        final /* synthetic */ updateConflicts.1 this$0;
                        final /* synthetic */ String $description$inlined;
                        final /* synthetic */ ArrayList $newConflicts$inlined;
                        final /* synthetic */ ArrayList $newReversedRoots$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$description$inlined = string;
                            this.$newConflicts$inlined = arrayList;
                            this.$newReversedRoots$inlined = arrayList2;
                        }

                        public final void run() {
                            boolean bl = false;
                            ((Listener)GitConflictsPanel.access$getEventDispatcher$p(this.this$0.this$0).getMulticaster()).onDescriptionChange(this.$description$inlined);
                            GitConflictsPanel.access$getConflicts$p(this.this$0.this$0).clear();
                            GitConflictsPanel.access$getConflicts$p(this.this$0.this$0).addAll(this.$newConflicts$inlined);
                            GitConflictsPanel.access$getReversedRoots$p(this.this$0.this$0).clear();
                            GitConflictsPanel.access$getReversedRoots$p(this.this$0.this$0).addAll(this.$newReversedRoots$inlined);
                            GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0).setChangesToDisplay(GitConflictsPanel.access$getConflicts$p(this.this$0.this$0));
                            if (GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0).getSelectionCount() == 0) {
                                TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0))));
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            {
                this.this$0 = gitConflictsPanel;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canShowMergeWindowForSelection() {
        Object element$iv;
        GitConflict it;
        List<GitConflict> selectedConflicts = this.getSelectedConflicts();
        Iterable $this$any$iv = selectedConflicts;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (GitConflict)element$iv;
            boolean bl = false;
        } while (!this.mergeHandler.canResolveConflict(it));
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$none$iv = selectedConflicts;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (GitConflict)element$iv;
            boolean bl2 = false;
        } while (!this.getConflictOperationLock(it).isLocked());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void showMergeWindowForSelection() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getSelectedConflicts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitConflict it = (GitConflict)element$iv$iv;
            boolean bl = false;
            if (!this.mergeHandler.canResolveConflict(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (conflicts.isEmpty()) {
            return;
        }
        HashSet reversed = new HashSet(this.reversedRoots);
        for (GitConflict conflict : conflicts) {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(conflict.getFilePath().getPath());
            if (file == null) {
                VcsNotifier.getInstance((Project)this.project).notifyError("Can't Resolve Conflict", "Can't find file for " + conflict.getFilePath());
                continue;
            }
            BackgroundableActionLock lock = this.getConflictOperationLock(conflict);
            MergeConflictResolveUtil.INSTANCE.showMergeWindow(this.project, file, lock, (Function0<? extends GitMergeHandler.Resolver>)((Function0)new Function0<GitMergeHandler.Resolver>(this, conflict, file, reversed){
                final /* synthetic */ GitConflictsPanel this$0;
                final /* synthetic */ GitConflict $conflict;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ HashSet $reversed;

                @NotNull
                public final GitMergeHandler.Resolver invoke() {
                    return GitConflictsPanel.access$getMergeHandler$p(this.this$0).resolveConflict(this.$conflict, this.$file, this.$reversed.contains(this.$conflict.getRoot()));
                }
                {
                    this.this$0 = gitConflictsPanel;
                    this.$conflict = gitConflict;
                    this.$file = virtualFile;
                    this.$reversed = hashSet;
                    super(0);
                }
            }));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAcceptConflictSideForSelection() {
        GitConflict it;
        List<GitConflict> selectedConflicts = this.getSelectedConflicts();
        Collection collection = selectedConflicts;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$none$iv = selectedConflicts;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (GitConflict)element$iv;
            boolean bl3 = false;
        } while (!this.getConflictOperationLock(it).isLocked());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void acceptConflictSideForSelection(boolean takeTheirs) {
        boolean bl;
        List locks;
        HashSet reversed;
        List<GitConflict> conflicts;
        block7: {
            void $this$mapTo$iv$iv;
            conflicts = this.getSelectedConflicts();
            if (conflicts.isEmpty()) {
                return;
            }
            reversed = new HashSet(this.reversedRoots);
            Iterable $this$map$iv = conflicts;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GitConflict gitConflict = (GitConflict)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                BackgroundableActionLock backgroundableActionLock = this.getConflictOperationLock((GitConflict)it);
                collection.add(backgroundableActionLock);
            }
            locks = (List)destination$iv$iv;
            Iterable $this$any$iv = locks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
                    boolean bl3 = false;
                    if (!it.isLocked()) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$forEach$iv = locks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
            boolean bl4 = false;
            it.lock();
        }
        new Task.Backgroundable(this, conflicts, reversed, takeTheirs, locks, this.project, StringUtil.pluralize((String)"Resolving Conflict", (int)conflicts.size()), true){
            final /* synthetic */ GitConflictsPanel this$0;
            final /* synthetic */ List $conflicts;
            final /* synthetic */ HashSet $reversed;
            final /* synthetic */ boolean $takeTheirs;
            final /* synthetic */ List $locks;

            public void run(@NotNull ProgressIndicator indicator) {
                GitConflictsPanel.access$getMergeHandler$p(this.this$0).acceptOneVersion(this.$conflicts, this.$reversed, this.$takeTheirs);
            }

            public void onFinished() {
                Iterable $this$forEach$iv = this.$locks;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
                    boolean bl = false;
                    it.unlock();
                }
            }
            {
                this.this$0 = this$0;
                this.$conflicts = $captured_local_variable$1;
                this.$reversed = $captured_local_variable$2;
                this.$takeTheirs = $captured_local_variable$3;
                this.$locks = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        }.queue();
    }

    private final BackgroundableActionLock getConflictOperationLock(GitConflict conflict) {
        return BackgroundableActionLock.getLock((Project)this.project, (Object[])new Object[]{conflict.getFilePath()});
    }

    /*
     * WARNING - void declaration
     */
    public GitConflictsPanel(@NotNull Project project, @NotNull GitMergeHandler mergeHandler) {
        void $this$apply;
        this.project = project;
        this.mergeHandler = mergeHandler;
        this.conflicts = new ArrayList();
        this.reversedRoots = new HashSet();
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.conflictsTree = new MyChangesTree(this.project);
        this.conflictsTree.setKeepTreeState(true);
        this.updateQueue = new MergingUpdateQueue("GitConflictsView", 300, true, (JComponent)((Object)this.conflictsTree), (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        MainPanel mainPanel = new MainPanel();
        boolean bl = false;
        boolean bl2 = false;
        MainPanel mainPanel2 = mainPanel;
        GitConflictsPanel gitConflictsPanel = this;
        boolean bl3 = false;
        $this$apply.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.conflictsTree))), "Center");
        Unit unit = Unit.INSTANCE;
        gitConflictsPanel.panel = mainPanel;
        this.conflictsTree.setDoubleClickHandler((Processor)new Processor<MouseEvent>(){

            public final boolean process(MouseEvent e) {
                boolean bl;
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)conflictsTree)), (MouseEvent)e)) {
                    bl = false;
                } else {
                    this.showMergeWindowForSelection();
                    bl = true;
                }
                return bl;
            }
        });
        this.conflictsTree.setEnterKeyHandler((Processor)new Processor<KeyEvent>(){

            public final boolean process(KeyEvent it) {
                this.showMergeWindowForSelection();
                return true;
            }
        });
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        connection.subscribe(GitStagingAreaHolder.TOPIC, (Object)new GitStagingAreaHolder.StagingAreaListener(){

            @Override
            public final void stagingAreaChanged(@NotNull GitRepository it) {
                this.updateConflicts();
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(@NotNull GitRepository it) {
                this.updateConflicts();
            }
        });
        this.updateConflicts();
        this.updateQueue.sendFlush();
    }

    public static final /* synthetic */ GitMergeHandler access$getMergeHandler$p(GitConflictsPanel $this) {
        return $this.mergeHandler;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(GitConflictsPanel $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ List access$getConflicts$p(GitConflictsPanel $this) {
        return $this.conflicts;
    }

    public static final /* synthetic */ Set access$getReversedRoots$p(GitConflictsPanel $this) {
        return $this.reversedRoots;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$MainPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lgit4idea/conflicts/GitConflictsPanel;)V", "getData", "", "dataId", "", "intellij.vcs.git"})
    private final class MainPanel
    extends JPanel
    implements DataProvider {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = GitConflictsPanel.this.getSelectedConflicts();
                Project project = GitConflictsPanel.this.project;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    GitConflict it = (GitConflict)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getFilePath().getVirtualFile() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VirtualFile it$iv$iv = virtualFile;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return ChangesUtil.getNavigatableArray((Project)project, list.stream());
            }
            return null;
        }

        public MainPanel() {
            super(new BorderLayout());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$Listener;", "Ljava/util/EventListener;", "onDescriptionChange", "", "description", "", "intellij.vcs.git"})
    public static interface Listener
    extends EventListener {
        public void onDescriptionChange(@NotNull String var1);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onDescriptionChange(@NotNull Listener $this, @NotNull String description) {
            }
        }
    }
}

