/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitLineHandlerListener;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitSimpleEventDetector
implements GitLineHandlerListener {
    @NotNull
    private final Event myEvent;
    private boolean myHappened;

    public GitSimpleEventDetector(@NotNull Event event) {
        this.myEvent = event;
    }

    @Override
    public void onLineAvailable(@NotNull String line, Key outputType) {
        if (this.myEvent.matches(line)) {
            this.myHappened = true;
        }
    }

    public boolean hasHappened() {
        return this.myHappened;
    }

    public static enum Event {
        CHERRY_PICK_CONFLICT("after resolving the conflicts"),
        LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK("would be overwritten by merge"),
        UNMERGED_PREVENTING_CHECKOUT("you need to resolve your current index first"),
        UNMERGED_PREVENTING_MERGE("is not possible because you have unmerged files"),
        BRANCH_NOT_FULLY_MERGED("is not fully merged"),
        MERGE_CONFLICT("Automatic merge failed; fix conflicts and then commit the result"),
        MERGE_CONFLICT_ON_UNSTASH("conflict"),
        ALREADY_UP_TO_DATE("Already up-to-date", "Already up to date"),
        INVALID_REFERENCE("invalid reference:");

        private final List<String> myDetectionStrings;

        private Event(String ... detectionStrings) {
            this.myDetectionStrings = Arrays.asList(detectionStrings);
        }

        boolean matches(@NotNull String line) {
            return ContainerUtil.exists(this.myDetectionStrings, s -> StringUtil.containsIgnoreCase((String)line, (String)s));
        }
    }
}

