/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitSimpleEditorHandler;
import git4idea.rebase.GitUnstructuredEditor;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitImplBase
implements Git {
    private static final Logger LOG = Logger.getInstance(GitImplBase.class);
    public static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    public static final String[] PROGRESS_INDICATORS = new String[]{"Counting objects:", "Enumerating objects:", "Compressing objects:", "Writing objects:", "Receiving objects:", "Resolving deltas:", "Finding sources:"};
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        return GitImplBase.run(handler, GitImplBase.getCollectingCollector());
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<? extends GitLineHandler> handlerConstructor) {
        return GitImplBase.run(handlerConstructor, (Computable<? extends OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        return new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (Registry.is((String)"git.allow.stderr.to.stdout.mixing") && !GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }
        };
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        return GitImplBase.run(handler, new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                this.addErrorLine(line);
            }
        });
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<? extends GitLineHandler> handlerConstructor, @NotNull Computable<? extends OutputCollector> outputCollectorConstructor) {
        GitCommandResult result2;
        int authAttempt = 0;
        do {
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            OutputCollector outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            boolean isCredHelperUsed = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            result2 = GitImplBase.run(handler, outputCollector);
            if (isCredHelperUsed != GitVcsApplicationSettings.getInstance().isUseCredentialHelper()) continue;
            ++authAttempt;
        } while (result2.isAuthenticationFailed() && authAttempt < 2);
        return result2;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static GitHandlerRebaseEditorManager prepareGeneralPurposeEditor(@NotNull Project project, @NotNull GitLineHandler handler) {
        return GitHandlerRebaseEditorManager.prepareEditor(handler, new GitSimpleEditorHandler(project));
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull GitVersion version, @NotNull OutputCollector outputCollector) {
        boolean canSuppressOptionalLocks;
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        boolean bl = canSuppressOptionalLocks = Registry.is((String)"git.use.no.optional.locks") && GitVersionSpecialty.ENV_GIT_OPTIONAL_LOCKS_ALLOWED.existsIn(version);
        if (canSuppressOptionalLocks) {
            handler.addCustomEnvironmentVariable("GIT_OPTIONAL_LOCKS", "0");
        }
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            return GitCommandResult.error("Error processing input stream: " + e.getLocalizedMessage());
        }
        return new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput);
    }

    @NotNull
    public static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        HashMap<String, String> environment = new HashMap<String, String>(5);
        int logLevel = Registry.intValue((String)"git.execution.trace");
        if (logLevel == 0) {
            environment.put("GIT_TRACE", "0");
            if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
                environment.put("GIT_TRACE_PACK_ACCESS", "");
            }
            environment.put("GIT_TRACE_PACKET", "");
            environment.put("GIT_TRACE_PERFORMANCE", "0");
            environment.put("GIT_TRACE_SETUP", "0");
        } else {
            String logFile = PathManager.getLogPath() + "/gittrace.log";
            if ((logLevel & 1) == 1) {
                environment.put("GIT_TRACE", logFile);
            }
            if ((logLevel & 2) == 2) {
                environment.put("GIT_TRACE_PACK_ACCESS", logFile);
            }
            if ((logLevel & 4) == 4) {
                environment.put("GIT_TRACE_PACKET", logFile);
            }
            if ((logLevel & 8) == 8) {
                environment.put("GIT_TRACE_PERFORMANCE", logFile);
            }
            if ((logLevel & 0x10) == 16) {
                environment.put("GIT_TRACE_SETUP", logFile);
            }
        }
        return environment;
    }

    public static boolean loadFileAndShowInSimpleEditor(@NotNull Project project, @Nullable VirtualFile root, @NotNull File file, @NotNull String dialogTitle, @NotNull String okButtonText) throws IOException {
        String encoding = root == null ? "UTF-8" : GitConfigUtil.getCommitEncoding(project, root);
        String initialText = StringUtil.trimLeading((String)GitImplBase.ignoreComments(FileUtil.loadFile((File)file, (String)encoding)));
        String newText = GitImplBase.showUnstructuredEditorAndWait(project, root, initialText, dialogTitle, okButtonText);
        if (newText == null) {
            return false;
        }
        FileUtil.writeToFile((File)file, (byte[])newText.getBytes(encoding));
        return true;
    }

    @Nullable
    private static String showUnstructuredEditorAndWait(@NotNull Project project, @Nullable VirtualFile root, @NotNull String initialText, @NotNull String dialogTitle, @NotNull String okButtonText) {
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitUnstructuredEditor editor = new GitUnstructuredEditor(project, root, initialText, dialogTitle, okButtonText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    @NotNull
    private static String ignoreComments(@NotNull String text) {
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
        return ((StreamEx)StreamEx.of((Object[])lines).filter(line -> !line.startsWith("\u0001"))).joining();
    }

    @NotNull
    private static GitCommandResult handlePreValidationException(@Nullable Project project, @NotNull Exception e) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            throw new ProcessCanceledException((Throwable)e);
        }
        return GitCommandResult.startError(GitBundle.getString("git.executable.validation.error.start.title") + ": \n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e));
    }

    private static void writeOutputToConsole(final @NotNull GitLineHandler handler) {
        if (handler.isSilent()) {
            return;
        }
        Project project = handler.project();
        if (project != null && !project.isDefault()) {
            final GitVcsConsoleWriter vcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            String workingDir = GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory());
            vcsConsoleWriter.showCommandLine(String.format("[%s] %s", workingDir, handler.printableCommandLine()));
            handler.addLineListener(new GitLineHandlerListener(){
                private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (StringUtil.isEmptyOrSpaces((String)line)) {
                        return;
                    }
                    if (outputType == ProcessOutputTypes.SYSTEM) {
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDOUT && handler.isStdoutSuppressed()) {
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDERR && handler.isStderrSuppressed()) {
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDERR && GitImplBase.looksLikeProgress(line)) {
                        return;
                    }
                    ArrayList<Pair<String, Key>> lineChunks = new ArrayList<Pair<String, Key>>();
                    this.myAnsiEscapeDecoder.escapeText(line, outputType, (text, key) -> lineChunks.add(Pair.create((Object)text, (Object)key)));
                    vcsConsoleWriter.showMessage(lineChunks);
                }
            });
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler) {
        Project project = handler.project();
        GitCommand.LockingPolicy lockingPolicy = handler.getCommand().lockingPolicy();
        if (project == null || project.isDefault() || lockingPolicy == GitCommand.LockingPolicy.READ) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        final ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
        executionLock.writeLock().lock();
        return new AccessToken(){

            public void finish() {
                executionLock.writeLock().unlock();
            }
        };
    }

    private static boolean looksLikeProgress(@NotNull String line) {
        String trimmed = StringUtil.trimStart((String)line, (String)REMOTE_PROGRESS_PREFIX);
        return ContainerUtil.exists((Object[])PROGRESS_INDICATORS, indicator -> StringUtil.startsWith((CharSequence)trimmed, (CharSequence)indicator));
    }

    private static boolean looksLikeError(@NotNull String text) {
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator));
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                return workingDir.getName();
            }
            if (relPath != null) {
                return FileUtil.toSystemDependentName((String)relPath);
            }
        }
        return workingDir.getPath();
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR && !GitImplBase.looksLikeProgress(line)) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(@NotNull Throwable t) {
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived(GitBundle.message("git.executable.unknown.error.message", t.getLocalizedMessage()));
        }
    }
}

