/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitHttpLoginDialog;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    private static final String HTTP_SCHEME_URL_PREFIX = "http://";
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myPresetUrl;
    @NotNull
    private final File myWorkingDirectory;
    @NotNull
    private final GitAuthenticationGate myAuthenticationGate;
    @NotNull
    private final GitAuthenticationMode myAuthenticationMode;
    @Nullable
    private volatile ProviderAndData myProviderAndData = null;
    private volatile boolean myCredentialHelperShouldBeUsed = false;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull Collection<String> urls, @NotNull File workingDirectory, @NotNull GitAuthenticationGate authenticationGate, @NotNull GitAuthenticationMode authenticationMode) {
        this.myProject = project;
        this.myPresetUrl = GitHttpGuiAuthenticator.findFirstHttpUrl(urls);
        this.myWorkingDirectory = workingDirectory;
        this.myAuthenticationGate = authenticationGate;
        this.myAuthenticationMode = authenticationMode;
    }

    @Nullable
    private static String findFirstHttpUrl(@NotNull Collection<String> urls) {
        return (String)ContainerUtil.find(urls, url -> ((String)UriUtil.splitScheme((String)url).getFirst()).startsWith("http"));
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        ProviderAndData newData;
        ProviderAndData providerAndData = this.myProviderAndData;
        if (providerAndData != null) {
            LOG.debug("askPassword. Data already filled in askUsername.");
            return providerAndData.getPassword();
        }
        Couple<String> usernameAndUrl = GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl(this.getRequiredUrl(url));
        String login = (String)usernameAndUrl.first;
        if (login == null) {
            LOG.debug("askPassword. login unknown, cannot determine password without login");
            return "";
        }
        String unifiedUrl = (String)usernameAndUrl.second;
        LOG.debug("askPassword. gitUrl=" + url + ", unifiedUrl=" + unifiedUrl);
        this.myProviderAndData = newData = this.acquireData(unifiedUrl, provider -> provider.getDataForKnownLogin(login));
        if (newData != null) {
            LOG.debug("askPassword. " + newData.toString());
            return newData.getPassword();
        }
        LOG.debug("askPassword. no data provided");
        return "";
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        ProviderAndData providerAndData;
        String unifiedUrl = (String)GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl((String)this.getRequiredUrl((String)url)).second;
        LOG.debug("askUsername. gitUrl=" + url + ", unifiedUrl=" + unifiedUrl);
        this.myProviderAndData = providerAndData = this.acquireData(unifiedUrl, AuthDataProvider::getData);
        if (providerAndData != null) {
            LOG.debug("askUsername. " + providerAndData.toString());
            return providerAndData.getLogin();
        }
        LOG.debug("askUsername. no data provided");
        return "";
    }

    @Nullable
    private ProviderAndData acquireData(@NotNull String unifiedUrl, @NotNull Function<? super AuthDataProvider, ? extends AuthData> dataAcquirer) {
        return this.myAuthenticationGate.waitAndCompute(() -> {
            try {
                for (AuthDataProvider provider : this.getProviders(unifiedUrl)) {
                    AuthData data = (AuthData)dataAcquirer.apply(provider);
                    if (data == null || data.getPassword() == null) continue;
                    return new ProviderAndData(provider, data.getLogin(), data.getPassword());
                }
                return null;
            }
            catch (ProcessCanceledException pce) {
                this.myAuthenticationGate.cancel();
                return new ProviderAndData(new CancelledProvider(unifiedUrl), "", "");
            }
            catch (CredentialHelperShouldBeUsedException e) {
                this.myAuthenticationGate.cancel();
                this.myCredentialHelperShouldBeUsed = true;
                return null;
            }
        });
    }

    @NotNull
    private List<AuthDataProvider> getProviders(@NotNull String unifiedUrl) {
        ArrayList<AuthDataProvider> delegates = new ArrayList<AuthDataProvider>();
        PasswordSafeProvider passwordSafeProvider = new PasswordSafeProvider(unifiedUrl, GitRememberedInputs.getInstance(), PasswordSafe.getInstance());
        boolean showActionForGitHelper = GitConfigUtil.isCredentialHelperUsed(this.myProject, this.myWorkingDirectory);
        DialogProvider dialogProvider = new DialogProvider(unifiedUrl, this.myProject, passwordSafeProvider, showActionForGitHelper);
        if (this.myAuthenticationMode != GitAuthenticationMode.NONE) {
            delegates.add(passwordSafeProvider);
        }
        List extensionAdapterProviders = ContainerUtil.map((Object[])GitHttpAuthDataProvider.EP_NAME.getExtensions(), provider -> new ExtensionAdapterProvider(unifiedUrl, this.myProject, (GitHttpAuthDataProvider)provider));
        if (this.myAuthenticationMode == GitAuthenticationMode.SILENT) {
            delegates.addAll(ContainerUtil.filter((Collection)extensionAdapterProviders, p -> ((ExtensionAdapterProvider)p).myDelegate.isSilent()));
        } else if (this.myAuthenticationMode == GitAuthenticationMode.FULL) {
            delegates.addAll(extensionAdapterProviders);
            delegates.add(dialogProvider);
        }
        return delegates;
    }

    @Override
    public void saveAuthData() {
        ProviderAndData providerAndData = this.myProviderAndData;
        if (providerAndData == null) {
            return;
        }
        LOG.debug("saveAuthData. " + providerAndData.toString());
        providerAndData.getProvider().onAuthSuccess();
    }

    @Override
    public void forgetPassword() {
        ProviderAndData providerAndData = this.myProviderAndData;
        if (providerAndData == null) {
            return;
        }
        LOG.debug("forgetPassword. " + providerAndData.toString());
        providerAndData.getProvider().onAuthFailure();
    }

    @Override
    public boolean wasCancelled() {
        if (this.myCredentialHelperShouldBeUsed) {
            return false;
        }
        ProviderAndData providerAndData = this.myProviderAndData;
        return providerAndData != null && providerAndData.getProvider() instanceof CancelledProvider;
    }

    @Override
    public boolean wasRequested() {
        return this.myProviderAndData != null;
    }

    @NotNull
    private String getRequiredUrl(@Nullable String urlFromGit) {
        if (urlFromGit != null && !StringUtil.isEmptyOrSpaces((String)urlFromGit)) {
            return urlFromGit;
        }
        if (this.myPresetUrl == null) {
            throw new IllegalStateException("Invalid remote urls in handler");
        }
        return this.myPresetUrl;
    }

    @NotNull
    private static Couple<String> splitToUsernameAndUnifiedUrl(@NotNull String url) {
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            return Couple.of(null, (Object)url);
        }
        Couple couple = UriUtil.splitScheme((String)url);
        String urlWithoutScheme = (String)couple.second;
        if (StringUtil.isEmptyOrSpaces((String)urlWithoutScheme)) {
            return Couple.of(null, (Object)url);
        }
        int i2 = urlWithoutScheme.indexOf(64);
        if (i2 <= 0) {
            return Couple.of(null, (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme));
        }
        return Couple.of((Object)urlWithoutScheme.substring(0, i2), (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme.substring(i2 + 1)));
    }

    private static class ProviderAndData {
        @NotNull
        private final AuthDataProvider myProvider;
        @NotNull
        private final String myLogin;
        @NotNull
        private final String myPassword;

        private ProviderAndData(@NotNull AuthDataProvider provider, @NotNull String login, @NotNull String password) {
            this.myProvider = provider;
            this.myLogin = login;
            this.myPassword = password;
        }

        @NotNull
        private AuthDataProvider getProvider() {
            return this.myProvider;
        }

        @NotNull
        private String getLogin() {
            return this.myLogin;
        }

        @NotNull
        private String getPassword() {
            return this.myPassword;
        }

        public String toString() {
            return "provider='" + this.myProvider.getName() + "', login='" + this.myLogin + '\'';
        }
    }

    private static class CancelledProvider
    extends AuthDataProvider {
        CancelledProvider(@NotNull String url) {
            super(url);
        }

        @Override
        @NotNull
        String getName() {
            return "Cancelled";
        }

        @Override
        @Nullable
        AuthData getData() {
            return new AuthData("", "");
        }

        @Override
        @Nullable
        AuthData getDataForKnownLogin(@NotNull String login) {
            return new AuthData("", "");
        }

        @Override
        void onAuthSuccess() {
        }

        @Override
        void onAuthFailure() {
        }
    }

    @VisibleForTesting
    static class PasswordSafeProvider
    extends AuthDataProvider {
        @NotNull
        private final DvcsRememberedInputs myRememberedInputs;
        @NotNull
        private final PasswordSafe myPasswordSafe;
        private AuthData myData;
        private boolean mySavePassword = false;

        PasswordSafeProvider(@NotNull String url, @NotNull DvcsRememberedInputs gitRememberedInputs, @NotNull PasswordSafe passwordSafe) {
            super(url);
            this.myRememberedInputs = gitRememberedInputs;
            this.myPasswordSafe = passwordSafe;
        }

        @Override
        @NotNull
        public String getName() {
            return "Password Safe";
        }

        @Override
        @Nullable
        public AuthData getData() {
            String rememberedLogin = this.getRememberedLogin(this.myUrl);
            if (rememberedLogin == null) {
                return null;
            }
            return this.getDataForKnownLogin(rememberedLogin);
        }

        @Nullable
        public String getRememberedLogin(@NotNull String url) {
            return this.myRememberedInputs.getUserNameForUrl(url);
        }

        @Override
        @Nullable
        public AuthData getDataForKnownLogin(@NotNull String login) {
            String key = PasswordSafeProvider.makeKey(this.myUrl, login);
            Credentials credentials = CredentialAttributesKt.getAndMigrateCredentials((CredentialAttributes)PasswordSafeProvider.oldCredentialAttributes(key), (CredentialAttributes)PasswordSafeProvider.credentialAttributes(key));
            String password = StringUtil.nullize((String)(credentials == null ? null : credentials.getPasswordAsString()));
            this.myData = new AuthData(login, password);
            return this.myData;
        }

        @Override
        public void onAuthSuccess() {
        }

        @Override
        public void onAuthFailure() {
            if (this.myData == null) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(this.myUrl, this.myData.getLogin());
            CredentialAttributes attributes = PasswordSafeProvider.credentialAttributes(key);
            LOG.debug("forgetPassword. key=" + attributes.getUserName());
            this.myPasswordSafe.set(attributes, null);
        }

        public void setData(@NotNull AuthData data) {
            this.myData = data;
        }

        public void setRememberPassword(boolean remember) {
            this.mySavePassword = remember;
            this.myPasswordSafe.setRememberPasswordByDefault(remember);
        }

        public boolean isRememberPasswordByDefault() {
            return this.myPasswordSafe.isRememberPasswordByDefault();
        }

        public void savePassword(@NotNull String url) {
            if (this.myData == null || this.myData.getPassword() == null) {
                return;
            }
            this.myRememberedInputs.addUrl(url, this.myData.getLogin());
            if (!this.mySavePassword) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(url, this.myData.getLogin());
            Credentials credentials = new Credentials(key, this.myData.getPassword());
            this.myPasswordSafe.set(PasswordSafeProvider.credentialAttributes(key), credentials);
        }

        @VisibleForTesting
        @NotNull
        static CredentialAttributes credentialAttributes(@NotNull String key) {
            return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Git HTTP", (String)key), key, PASS_REQUESTER);
        }

        @NotNull
        private static CredentialAttributes oldCredentialAttributes(@NotNull String key) {
            return CredentialAttributesKt.CredentialAttributes((Class)PASS_REQUESTER, (String)key);
        }

        @VisibleForTesting
        @NotNull
        static String makeKey(@NotNull String url, @Nullable String login) {
            if (login == null) {
                return url;
            }
            Couple pair = UriUtil.splitScheme((String)url);
            String scheme = (String)pair.getFirst();
            if (!StringUtil.isEmpty((String)scheme)) {
                return scheme + "://" + login + "@" + (String)pair.getSecond();
            }
            return login + "@" + url;
        }
    }

    private static class DialogProvider
    extends AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PasswordSafeProvider myPasswordSafeDelegate;
        private final boolean showActionForGitHelper;
        private boolean myCancelled;
        private boolean myDataForSession = false;

        protected DialogProvider(@NotNull String url, @NotNull Project project, @NotNull PasswordSafeProvider passwordSafeDelegate, boolean showActionForGitHelper) {
            super(url);
            this.myProject = project;
            this.myPasswordSafeDelegate = passwordSafeDelegate;
            this.showActionForGitHelper = showActionForGitHelper;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myDataForSession ? "Session Provider" : "Dialog";
        }

        @Override
        @Nullable
        public AuthData getData() {
            return this.getDataFromDialog(this.myUrl, this.myPasswordSafeDelegate.getRememberedLogin(this.myUrl), true);
        }

        @Override
        @Nullable
        public AuthData getDataForKnownLogin(@NotNull String login) {
            return this.getDataFromDialog(this.myUrl, login, false);
        }

        @Override
        public void onAuthSuccess() {
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthSuccess();
        }

        @Override
        public void onAuthFailure() {
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthFailure();
        }

        @NotNull
        private AuthData getDataFromDialog(@NotNull String url, @Nullable String username, boolean editableUsername) {
            HashMap<String, InteractiveGitHttpAuthDataProvider> providers = new HashMap<String, InteractiveGitHttpAuthDataProvider>();
            for (GitRepositoryHostingService service : (GitRepositoryHostingService[])GitRepositoryHostingService.EP_NAME.getExtensions()) {
                InteractiveGitHttpAuthDataProvider provider;
                InteractiveGitHttpAuthDataProvider interactiveGitHttpAuthDataProvider = provider = editableUsername || username == null ? service.getInteractiveAuthDataProvider(this.myProject, url) : service.getInteractiveAuthDataProvider(this.myProject, url, username);
                if (provider == null) continue;
                providers.put(service.getServiceDisplayName(), provider);
            }
            GitHttpLoginDialog dialog2 = this.showAuthDialog((String)UriUtil.splitScheme((String)url).second, username, editableUsername, providers);
            LOG.debug("Showed dialog:" + (dialog2.isOK() ? "OK" : "Cancel"));
            if (!dialog2.isOK()) {
                this.myCancelled = true;
                if (dialog2.getExitCode() == 2) {
                    LOG.debug("Credential helper is enabled");
                    GitVcsApplicationSettings.getInstance().setUseCredentialHelper(true);
                    throw new CredentialHelperShouldBeUsedException();
                }
                throw new ProcessCanceledException();
            }
            this.myPasswordSafeDelegate.setRememberPassword(dialog2.getRememberPassword());
            AuthData sessionAuthData = dialog2.getExternalAuthData();
            if (sessionAuthData != null) {
                this.myDataForSession = true;
                return sessionAuthData;
            }
            AuthData authData = new AuthData(dialog2.getUsername(), dialog2.getPassword());
            this.myPasswordSafeDelegate.setData(authData);
            this.myPasswordSafeDelegate.savePassword(url);
            return authData;
        }

        @NotNull
        private GitHttpLoginDialog showAuthDialog(@NotNull String url, @Nullable String username, boolean editableUsername, @NotNull Map<String, ? extends InteractiveGitHttpAuthDataProvider> interactiveProviders) {
            Ref dialogRef = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                GitHttpLoginDialog dialog2 = new GitHttpLoginDialog(this.myProject, url, this.myPasswordSafeDelegate.isRememberPasswordByDefault(), username, editableUsername, this.showActionForGitHelper);
                dialog2.setInteractiveDataProviders(interactiveProviders);
                dialogRef.set((Object)dialog2);
                DialogManager.show(dialog2);
            }, ModalityState.any());
            return (GitHttpLoginDialog)((Object)dialogRef.get());
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }
    }

    private static class ExtensionAdapterProvider
    extends AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitHttpAuthDataProvider myDelegate;
        private AuthData myData = null;

        protected ExtensionAdapterProvider(@NotNull String url, @NotNull Project project, @NotNull GitHttpAuthDataProvider provider) {
            super(url);
            this.myProject = project;
            this.myDelegate = provider;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myDelegate.getClass().getName();
        }

        @Override
        public AuthData getData() {
            this.myData = this.myDelegate.getAuthData(this.myProject, this.myUrl);
            return this.myData;
        }

        @Override
        public AuthData getDataForKnownLogin(@NotNull String login) {
            this.myData = this.myDelegate.getAuthData(this.myProject, this.myUrl, login);
            return this.myData;
        }

        @Override
        public void onAuthSuccess() {
        }

        @Override
        public void onAuthFailure() {
            if (this.myData != null) {
                this.myDelegate.forgetPassword(this.myProject, this.myUrl, this.myData);
            }
        }
    }

    private static abstract class AuthDataProvider {
        @NotNull
        protected final String myUrl;

        protected AuthDataProvider(@NotNull String url) {
            this.myUrl = url;
        }

        @NotNull
        abstract String getName();

        @Nullable
        abstract AuthData getData();

        @Nullable
        abstract AuthData getDataForKnownLogin(@NotNull String var1);

        abstract void onAuthSuccess();

        abstract void onAuthFailure();
    }

    static class CredentialHelperShouldBeUsedException
    extends RuntimeException
    implements ControlFlowException {
        CredentialHelperShouldBeUsedException() {
        }
    }
}

