/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class BufferingTextSplitter {
    @NotNull
    private final StringBuilder myLineBuffer = new StringBuilder();
    @NotNull
    private final Consumer<? super String> myLineConsumer;
    private boolean myCrLast = false;

    BufferingTextSplitter(@NotNull Consumer<? super String> lineConsumer) {
        this.myLineConsumer = lineConsumer;
    }

    public void process(char[] input, int contentLength) {
        block4: for (int i2 = 0; i2 < contentLength; ++i2) {
            char character = input[i2];
            switch (character) {
                case '\n': {
                    this.myLineBuffer.append(character);
                    this.sendLine();
                    continue block4;
                }
                case '\r': {
                    if (this.myCrLast) {
                        this.sendLine();
                    }
                    this.myLineBuffer.append(character);
                    this.myCrLast = true;
                    continue block4;
                }
                default: {
                    if (this.myCrLast) {
                        this.sendLine();
                    }
                    this.myLineBuffer.append(character);
                }
            }
        }
    }

    public void flush() {
        if (this.myLineBuffer.length() > 0) {
            this.sendLine();
        }
    }

    private void sendLine() {
        String text = this.myLineBuffer.toString();
        this.myLineBuffer.setLength(0);
        this.myCrLast = false;
        this.myLineConsumer.accept(text);
    }
}

