/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitRenameBranchOperation
extends GitBranchOperation {
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final String myCurrentName;
    @NotNull
    private final String myNewName;

    GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String currentName, @NotNull String newName, @NotNull List<? extends GitRepository> repositories) {
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.renameBranch(repository, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.update();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("git.rename.branch.could.not.rename.from.to", this.myCurrentName, this.myNewName), result2.getErrorOutputAsJoinedString());
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            result2.append(repository, this.myGit.renameBranch(repository, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]));
            repository.update();
        }
        if (result2.totalSuccess()) {
            this.myNotifier.notifySuccess(GitBundle.message("git.rename.branch.rollback.successful", new Object[0]), GitBundle.message("git.rename.branch.renamed.back.to", this.myCurrentName));
        } else {
            this.myNotifier.notifyError(GitBundle.message("git.rename.branch.rollback.failed", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return GitBundle.message("git.rename.branch.was.renamed.to", XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.wrapInHtmlTag((String)this.myCurrentName, (String)"code"), (String)"b"), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.wrapInHtmlTag((String)this.myNewName, (String)"code"), (String)"b"));
    }

    @Override
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getRollbackProposal() {
        return GitBundle.message("git.rename.branch.has.succeeded.for.the.following.repositories", this.getSuccessfulRepositories().size()) + "<br/>" + this.successfulRepositoriesJoined() + "<br/>" + GitBundle.message("git.rename.branch.you.may.rename.branch.back", this.myCurrentName);
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        return GitBundle.message("rename.branch.operation.name", new Object[0]);
    }
}

