/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.collect.Maps;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.config.GitSharedSettings;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteBranchOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteBranchOperation.class);
    static final String RESTORE = GitDeleteBranchOperation.getRestore();
    static final String VIEW_COMMITS = GitDeleteBranchOperation.getViewCommits();
    static final String DELETE_TRACKED_BRANCH = GitDeleteBranchOperation.getDeleteTrackedBranch();
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final Map<GitRepository, GitRemoteBranch> myTrackedBranches;
    @NotNull
    private final Map<GitRepository, UnmergedBranchInfo> myUnmergedToBranches;
    @NotNull
    private final Map<GitRepository, String> myDeletedBranchTips;

    GitDeleteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String branchName) {
        super(project, git, uiHandler, repositories);
        this.myBranchName = branchName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myTrackedBranches = GitDeleteBranchOperation.findTrackedBranches(repositories, branchName);
        this.myUnmergedToBranches = new HashMap<GitRepository, UnmergedBranchInfo>();
        this.myDeletedBranchTips = ContainerUtil.map2MapNotNull(repositories, repo -> {
            GitBranchesCollection branches2 = repo.getBranches();
            GitLocalBranch branch = branches2.findLocalBranch(this.myBranchName);
            if (branch == null) {
                LOG.error("Couldn't find branch by name " + this.myBranchName + " in " + repo);
                return null;
            }
            Hash hash = branches2.getHash(branch);
            if (hash == null) {
                LOG.error("Couldn't find hash for branch " + branch + " in " + repo);
                return null;
            }
            return Pair.create((Object)repo, (Object)hash.asString());
        });
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitBranchNotMergedToUpstreamDetector notMergedToUpstreamDetector;
            GitSimpleEventDetector notFullyMergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.branchDelete(repository, this.myBranchName, false, notFullyMergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.BRANCH_NOT_FULLY_MERGED), notMergedToUpstreamDetector = new GitBranchNotMergedToUpstreamDetector());
            if (result2.success()) {
                GitDeleteBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (notFullyMergedDetector.hasHappened()) {
                String baseBranch = notMergedToUpstreamDetector.getBaseBranch();
                if (baseBranch == null) {
                    baseBranch = (String)this.myCurrentHeads.get(repository);
                }
                this.myUnmergedToBranches.put(repository, new UnmergedBranchInfo(this.myDeletedBranchTips.get(repository), GitBranchUtil.stripRefsPrefix(baseBranch)));
                GitCommandResult forceDeleteResult = this.myGit.branchDelete(repository, this.myBranchName, true, new GitLineHandlerListener[0]);
                if (forceDeleteResult.success()) {
                    GitDeleteBranchOperation.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getErrorTitle(), forceDeleteResult.getErrorOutputAsHtmlString());
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(this.getErrorTitle(), result2.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
        }
    }

    @Override
    protected void notifySuccess() {
        boolean unmergedCommits = !this.myUnmergedToBranches.isEmpty();
        String message = GitBundle.message("delete.branch.operation.deleted.branch.bold", this.myBranchName);
        if (unmergedCommits) {
            message = message + "<br/>";
            message = message + GitBundle.message("delete.branch.operation.unmerged.commits.were.discarded", new Object[0]);
        }
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getRestore(), () -> this.restoreInBackground(notification)));
        if (unmergedCommits) {
            notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getViewCommits(), () -> this.viewUnmergedCommitsInBackground(notification)));
        }
        if (!this.myTrackedBranches.isEmpty() && GitDeleteBranchOperation.hasNoOtherTrackingBranch(this.myTrackedBranches, this.myBranchName) && this.trackedBranchIsNotProtected()) {
            notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getDeleteTrackedBranch(), () -> {
                notification.hideBalloon();
                this.deleteTrackedBranchInBackground();
            }));
        }
        this.myNotifier.notify(notification);
    }

    private boolean trackedBranchIsNotProtected() {
        return this.myTrackedBranches.values().stream().noneMatch(branch -> GitSharedSettings.getInstance(this.myProject).isBranchProtected(branch.getNameForRemoteOperations()));
    }

    private static boolean hasNoOtherTrackingBranch(@NotNull Map<GitRepository, GitRemoteBranch> trackedBranches, @NotNull String localBranch) {
        for (GitRepository repository : trackedBranches.keySet()) {
            if (!ContainerUtil.exists(repository.getBranchTrackInfos(), info -> !info.getLocalBranch().getName().equals(localBranch) && info.getRemoteBranch().equals(trackedBranches.get(repository)))) continue;
            return false;
        }
        return true;
    }

    private static void refresh(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (!result2.totalSuccess()) {
            this.myNotifier.notifyError(GitBundle.message("delete.branch.operation.error.during.rollback.of.branch.deletion", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult setTrackResult;
            GitCommandResult res = this.myGit.branchCreate(repository, this.myBranchName, this.myDeletedBranchTips.get(repository));
            result2.append(repository, res);
            GitRemoteBranch trackedBranch = this.myTrackedBranches.get(repository);
            if (trackedBranch != null && !(setTrackResult = this.myGit.setUpstream(repository, trackedBranch.getNameForLocalOperations(), this.myBranchName)).success()) {
                LOG.warn("Couldn't set " + this.myBranchName + " to track " + trackedBranch + " in " + repository.getRoot().getName() + ": " + setTrackResult.getErrorOutputAsJoinedString());
            }
            GitDeleteBranchOperation.refresh(repository);
        }
        return result2;
    }

    @NotNull
    private String getErrorTitle() {
        return GitBundle.message("delete.branch.operation.branch.was.not.deleted.error", this.myBranchName);
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return GitBundle.message("delete.branch.operation.deleted.branch", GitDeleteBranchOperation.formatBranchName(this.myBranchName));
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return GitBundle.message("delete.branch.operation.however.branch.deletion.has.succeeded.for.the.following", this.getSuccessfulRepositories().size()) + "<br/>" + this.successfulRepositoriesJoined() + "<br/>" + GitBundle.message("delete.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.myBranchName);
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        return GitBundle.message("delete.branch.operation.name", new Object[0]);
    }

    @NotNull
    private static String formatBranchName(@NotNull String name) {
        return GitUIUtil.bold(GitUIUtil.code(name));
    }

    private boolean showNotFullyMergedDialog(@NotNull Map<GitRepository, UnmergedBranchInfo> unmergedBranches) {
        HashMap<GitRepository, List<GitCommit>> history = new HashMap<GitRepository, List<GitCommit>>();
        for (GitRepository repository : this.getRepositories()) {
            if (unmergedBranches.containsKey(repository)) {
                UnmergedBranchInfo unmergedInfo = unmergedBranches.get(repository);
                history.put(repository, GitDeleteBranchOperation.getUnmergedCommits(repository, unmergedInfo.myTipOfDeletedUnmergedBranch, unmergedInfo.myBaseBranch));
                continue;
            }
            history.put(repository, Collections.emptyList());
        }
        Map baseBranches = Maps.asMap(unmergedBranches.keySet(), it -> ((UnmergedBranchInfo)unmergedBranches.get(it)).myBaseBranch);
        return this.myUiHandler.showBranchIsNotFullyMergedDialog(this.myProject, history, baseBranches, this.myBranchName);
    }

    @NotNull
    private static List<GitCommit> getUnmergedCommits(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String baseBranch) {
        String range = baseBranch + ".." + branchName;
        try {
            return GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get `git log " + range + "` in " + DvcsUtil.getShortRepositoryName((Repository)repository), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private static Map<GitRepository, GitRemoteBranch> findTrackedBranches(@NotNull Collection<? extends GitRepository> repositories, @NotNull String localBranchName) {
        HashMap<GitRepository, GitRemoteBranch> trackedBranches = new HashMap<GitRepository, GitRemoteBranch>();
        for (GitRepository gitRepository : repositories) {
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfo(gitRepository, localBranchName);
            if (trackInfo == null) continue;
            trackedBranches.put(gitRepository, trackInfo.getRemoteBranch());
        }
        return trackedBranches;
    }

    private void deleteTrackedBranchInBackground() {
        GitBrancher brancher = GitBrancher.getInstance(this.myProject);
        MultiMap<String, GitRepository> grouped = this.groupTrackedBranchesByName();
        for (String remoteBranch : grouped.keySet()) {
            brancher.deleteRemoteBranch(remoteBranch, new ArrayList(grouped.get((Object)remoteBranch)));
        }
    }

    @NotNull
    private MultiMap<String, GitRepository> groupTrackedBranchesByName() {
        MultiMap trackedBranchNames = MultiMap.create();
        for (GitRepository repository : this.myTrackedBranches.keySet()) {
            GitRemoteBranch trackedBranch = this.myTrackedBranches.get(repository);
            if (trackedBranch == null) continue;
            trackedBranchNames.putValue((Object)trackedBranch.getNameForLocalOperations(), (Object)repository);
        }
        return trackedBranchNames;
    }

    private void restoreInBackground(final @NotNull Notification notification) {
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.restoring.branch.process", this.myBranchName)){

            public void run(@NotNull ProgressIndicator indicator) {
                GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
            }
        }.queue();
    }

    private void rollbackBranchDeletion(@NotNull Notification notification) {
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            notification.expire();
        } else {
            this.myNotifier.notifyError(GitBundle.message("delete.branch.operation.could.not.restore.branch.error", GitDeleteBranchOperation.formatBranchName(this.myBranchName)), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private void viewUnmergedCommitsInBackground(final @NotNull Notification notification) {
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.collecting.unmerged.commits.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean restore = GitDeleteBranchOperation.this.showNotFullyMergedDialog(GitDeleteBranchOperation.this.myUnmergedToBranches);
                if (restore) {
                    GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
                }
            }
        }.queue();
    }

    @NotNull
    static String getRestore() {
        return GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.restore", new Object[0]);
    }

    @NotNull
    static String getViewCommits() {
        return GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.view.commits", new Object[0]);
    }

    @NotNull
    static String getDeleteTrackedBranch() {
        return GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.delete.tracked.branch", new Object[0]);
    }

    static class UnmergedBranchInfo {
        @NotNull
        private final String myTipOfDeletedUnmergedBranch;
        @NotNull
        private final String myBaseBranch;

        UnmergedBranchInfo(@NotNull String tipOfDeletedUnmergedBranch, @NotNull String baseBranch) {
            this.myTipOfDeletedUnmergedBranch = tipOfDeletedUnmergedBranch;
            this.myBaseBranch = baseBranch;
        }
    }

    private static class GitBranchNotMergedToUpstreamDetector
    implements GitLineHandlerListener {
        private static final Pattern PATTERN = Pattern.compile(".*'(.*)', even though it is merged to.*");
        @Nullable
        private String myBaseBranch;

        private GitBranchNotMergedToUpstreamDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myBaseBranch = matcher.group(1);
            }
        }

        @Nullable
        public String getBaseBranch() {
            return this.myBaseBranch;
        }
    }
}

