/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.ui.RepositoryComboboxListCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GitBranchIsNotFullyMergedDialog
extends DialogWrapper {
    @NotNull
    private final Map<GitRepository, List<GitCommit>> myCommits;
    @NotNull
    private final GitCommitListWithDiffPanel myCommitListWithDiffPanel;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final String myRemovedBranch;
    @NotNull
    private final Map<GitRepository, String> myBaseBranches;
    @NotNull
    private final GitRepository myInitialRepository;

    public static boolean showAndGetAnswer(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits2, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        GitBranchIsNotFullyMergedDialog dialog2 = new GitBranchIsNotFullyMergedDialog(project, commits2, baseBranches, removedBranch);
        DialogManager.show(dialog2);
        return dialog2.isOK();
    }

    private GitBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits2, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        super(project, false);
        this.myCommits = commits2;
        this.myRepositories = commits2.keySet();
        this.myBaseBranches = baseBranches;
        this.myRemovedBranch = removedBranch;
        this.myInitialRepository = this.calcInitiallySelectedRepository();
        this.myCommitListWithDiffPanel = new GitCommitListWithDiffPanel(project, new ArrayList<GitCommit>((Collection)this.myCommits.get(this.myInitialRepository)));
        this.init();
        this.setTitle(GitBundle.message("branch.not.fully.merged.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("branch.not.fully.merged.dialog.restore.button", new Object[0]));
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
    }

    @NotNull
    private GitRepository calcInitiallySelectedRepository() {
        for (GitRepository repository : this.myRepositories) {
            if (this.myCommits.get(repository).isEmpty()) continue;
            return repository;
        }
        throw new AssertionError((Object)("The dialog shouldn't be shown. Unmerged commits: " + this.myCommits));
    }

    @NotNull
    private String makeDescription(@NotNull GitRepository repository) {
        String baseBranch = this.myBaseBranches.get(repository);
        String description = baseBranch == null ? GitBundle.message("branch.not.fully.merged.dialog.all.commits.from.branch.were.merged", this.myRemovedBranch) : GitBundle.message("branch.not.fully.merged.dialog.the.branch.was.not.fully.merged.to", this.myRemovedBranch, baseBranch);
        return XmlStringUtil.wrapInHtml((CharSequence)description);
    }

    protected JComponent createNorthPanel() {
        final JBLabel descriptionLabel = new JBLabel(this.makeDescription(this.myInitialRepository));
        final JComboBox<GitRepository> repositorySelector = new JComboBox<GitRepository>(this.myRepositories.toArray(new GitRepository[0]));
        repositorySelector.setRenderer((ListCellRenderer<GitRepository>)new RepositoryComboboxListCellRenderer());
        repositorySelector.setSelectedItem(this.myInitialRepository);
        repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRepository selectedRepo = (GitRepository)repositorySelector.getSelectedItem();
                descriptionLabel.setText(GitBranchIsNotFullyMergedDialog.this.makeDescription(selectedRepo));
                GitBranchIsNotFullyMergedDialog.this.myCommitListWithDiffPanel.setCommits((List)GitBranchIsNotFullyMergedDialog.this.myCommits.get(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(GitBundle.message("branch.not.fully.merged.dialog.repository.label", new Object[0]));
        label.setLabelFor((Component)repoSelectorPanel);
        repoSelectorPanel.add((Component)label, "West");
        repoSelectorPanel.add(repositorySelector);
        if (this.myRepositories.size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descriptionLabel);
        northPanel.add((Component)repoSelectorPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add(this.myCommitListWithDiffPanel);
        return rootPanel;
    }

    protected Action @NotNull [] createLeftSideActions() {
        return new Action[]{this.getOKAction()};
    }

    protected Action @NotNull [] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        return new Action[]{cancelAction};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitListWithDiffPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitBranchIsNotFullyMergedDialog.class.getName();
    }
}

