/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitStash
extends GitRepositoryAction {
    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(GitBundle.message("stash.error.can.not.stash.changes.now", new Object[0]))) {
            return;
        }
        final GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        new Task.Backgroundable(project, GitBundle.getString("stashing.title"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitStash.this.getActionName());){
                    GitCommandResult result2 = Git.getInstance().runCommand(d.handler());
                    if (result2.success()) {
                        GitUtil.refreshVfsInRoot(d.getGitRoot());
                    } else {
                        VcsNotifier.getInstance((Project)project).notifyError("Stash Failed", result2.getErrorOutputAsHtmlString(), true);
                    }
                }
            }
        }.queue();
    }

    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.getString("stash.action.name");
    }
}

