/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.vcs.ViewUpdateInfoNotification;
import git4idea.GitBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.merge.MergeChangeCollector;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateSessionKt;
import git4idea.update.GitUpdatedRanges;
import git4idea.update.HashRange;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitMergeAction
extends GitRepositoryAction {
    GitMergeAction() {
    }

    @Nullable
    protected abstract DialogState displayDialog(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    @Override
    protected final void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        DialogState dialogState = this.displayDialog(project, gitRoots, defaultRoot);
        if (dialogState == null) {
            return;
        }
        this.perform(dialogState, project);
    }

    protected void perform(final @NotNull DialogState dialogState, final @NotNull Project project) {
        final VirtualFile selectedRoot = dialogState.selectedRoot;
        final Supplier<GitLineHandler> handlerProvider = dialogState.handlerProvider;
        final Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before update");
        final GitBranch selectedBranch = dialogState.selectedBranch;
        new Task.Backgroundable(project, dialogState.progressTitle, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                Git git = Git.getInstance();
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(selectedRoot, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(selectedRoot);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(selectedRoot);
                assert (repository != null) : "Repository can't be null for root " + selectedRoot;
                GitUpdatedRanges updatedRanges = null;
                if (repository.getCurrentBranch() != null) {
                    GitBranchPair refPair = new GitBranchPair(repository.getCurrentBranch(), selectedBranch);
                    updatedRanges = GitUpdatedRanges.calcInitialPositions(project, Collections.singletonMap(repository, refPair));
                }
                String beforeRevision = repository.getCurrentRevision();
                boolean setupRebaseEditor = GitMergeAction.this.shouldSetupRebaseEditor(project, selectedRoot);
                Ref rebaseEditorManager = Ref.create();
                try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitMergeAction.this.getActionName());){
                    GitCommandResult result2 = git.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> 1.lambda$run$0((Supplier)handlerProvider, setupRebaseEditor, rebaseEditorManager, project, selectedRoot, localChangesDetector, untrackedFilesDetector, mergeConflict)));
                    if (beforeRevision != null) {
                        GitRevisionNumber currentRev = new GitRevisionNumber(beforeRevision);
                        GitMergeAction.this.handleResult(result2, project, mergeConflict, localChangesDetector, untrackedFilesDetector, repository, currentRev, beforeLabel, updatedRanges, dialogState.commitAfterMerge);
                    }
                }
                finally {
                    if (!rebaseEditorManager.isNull()) {
                        ((GitHandlerRebaseEditorManager)rebaseEditorManager.get()).close();
                    }
                }
            }

            private static /* synthetic */ GitLineHandler lambda$run$0(Supplier handlerProvider2, boolean setupRebaseEditor, Ref rebaseEditorManager, Project project2, VirtualFile selectedRoot2, GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, GitSimpleEventDetector mergeConflict) {
                GitLineHandler handler = (GitLineHandler)handlerProvider2.get();
                if (setupRebaseEditor) {
                    if (!rebaseEditorManager.isNull()) {
                        ((GitHandlerRebaseEditorManager)rebaseEditorManager.get()).close();
                    }
                    GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(project2, selectedRoot2);
                    rebaseEditorManager.set((Object)GitHandlerRebaseEditorManager.prepareEditor(handler, editor));
                }
                handler.addLineListener(localChangesDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(mergeConflict);
                return handler;
            }
        }.queue();
    }

    protected boolean shouldSetupRebaseEditor(@NotNull Project project, VirtualFile selectedRoot) {
        return false;
    }

    private void handleResult(@NotNull GitCommandResult result2, @NotNull Project project, @NotNull GitSimpleEventDetector mergeConflictDetector, @NotNull GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, @NotNull GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, @NotNull GitRepository repository, @NotNull GitRevisionNumber currentRev, @NotNull Label beforeLabel, @Nullable GitUpdatedRanges updatedRanges, final boolean commitAfterMerge) {
        final VirtualFile root = repository.getRoot();
        if (mergeConflictDetector.hasHappened()) {
            final GitMerger merger = new GitMerger(project);
            new GitConflictResolver(project, Collections.singletonList(root), new GitConflictResolver.Params(project)){

                @Override
                protected boolean proceedAfterAllMerged() throws VcsException {
                    if (commitAfterMerge) {
                        merger.mergeCommit(root);
                    }
                    return true;
                }
            }.merge();
        }
        if (result2.success() || mergeConflictDetector.hasHappened()) {
            GitUtil.refreshVfsInRoot(root);
            repository.update();
            if (updatedRanges != null && AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(project))) && commitAfterMerge) {
                Notification notification;
                Map<GitRepository, HashRange> ranges = updatedRanges.calcCurrentPositions();
                GitUpdateInfoAsLog.NotificationData notificationData = new GitUpdateInfoAsLog(project, ranges).calculateDataAndCreateLogTab();
                if (notificationData != null) {
                    String title = GitUpdateSessionKt.getTitleForUpdateNotification(notificationData.getUpdatedFilesCount(), notificationData.getReceivedCommitsCount());
                    String content = GitUpdateSessionKt.getBodyForUpdateNotification(notificationData.getFilteredCommitsCount());
                    notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, content, NotificationType.INFORMATION, null);
                    notification.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.GitMergeAction.text.view.commits", new Object[0]), (Runnable)notificationData.getViewCommitAction()));
                } else {
                    notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]), "", NotificationType.INFORMATION, null);
                }
                VcsNotifier.getInstance((Project)project).notify(notification);
            } else {
                GitMergeAction.showUpdates(project, repository, currentRev, beforeLabel, this.getActionName());
            }
        } else if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, repository.getRoot(), this.getActionName(), localChangesDetector.getRelativeFilePaths());
        } else if (untrackedFilesDetector.wasMessageDetected()) {
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, untrackedFilesDetector.getRelativeFilePaths(), this.getActionName(), null);
        } else {
            GitUIUtil.notifyError(project, "Git " + this.getActionName() + " Failed", result2.getErrorOutputAsJoinedString(), true, null);
            repository.update();
        }
    }

    private static void showUpdates(@NotNull Project project, @NotNull GitRepository repository, @NotNull GitRevisionNumber currentRev, @NotNull Label beforeLabel, @NotNull String actionName) {
        try {
            UpdatedFiles files = UpdatedFiles.create();
            MergeChangeCollector collector = new MergeChangeCollector(project, repository, currentRev);
            collector.collect(files);
            GuiUtils.invokeLaterIfNeeded(() -> {
                ProjectLevelVcsManagerEx manager = (ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)project);
                UpdateInfoTree tree = manager.showUpdateProjectInfo(files, actionName, ActionInfo.UPDATE, false);
                if (tree != null) {
                    tree.setBefore(beforeLabel);
                    tree.setAfter(LocalHistory.getInstance().putSystemLabel(project, "After update"));
                    ViewUpdateInfoNotification.focusUpdateInfoTree((Project)project, (UpdateInfoTree)tree);
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        }
        catch (VcsException e) {
            GitVcs.getInstance(project).showErrors(Collections.singletonList(e), actionName);
        }
    }

    protected static class DialogState {
        final VirtualFile selectedRoot;
        final String progressTitle;
        final Supplier<GitLineHandler> handlerProvider;
        @NotNull
        final GitBranch selectedBranch;
        final boolean commitAfterMerge;
        @NotNull
        final List<String> selectedOptions;

        DialogState(@NotNull VirtualFile root, @NotNull String title, @NotNull Supplier<GitLineHandler> provider, @NotNull GitBranch selectedBranch, boolean commitAfterMerge, @NotNull List<String> selectedOptions) {
            this.selectedRoot = root;
            this.progressTitle = title;
            this.handlerProvider = provider;
            this.selectedBranch = selectedBranch;
            this.selectedOptions = selectedOptions;
            this.commitAfterMerge = commitAfterMerge;
        }
    }
}

