/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private JpsMavenRepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(JpsMavenRepositoryLibraryDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public RepositoryLibraryProperties(String mavenId, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(String mavenId, String packaging, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, packaging, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this(groupId, artifactId, version, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version, includeTransitiveDependencies, excludedDependencies));
    }

    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal((Object)this.myDescriptor, (Object)((RepositoryLibraryProperties)((Object)obj)).myDescriptor);
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    public RepositoryLibraryProperties getState() {
        return this;
    }

    public void loadState(@NotNull RepositoryLibraryProperties state) {
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getMavenId, null);
    }

    @Attribute(value="packaging")
    public String getPackaging() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getPackaging, "jar");
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    public void setPackaging(String packaging) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), packaging, this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    @Attribute(value="include-transitive-deps")
    public boolean isIncludeTransitiveDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::isIncludeTransitiveDependencies, Boolean.TRUE);
    }

    public void setIncludeTransitiveDependencies(boolean value) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), value, this.getExcludedDependencies());
    }

    public String getGroupId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getGroupId, null);
    }

    public String getArtifactId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactId, null);
    }

    public String getVersion() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getVersion, null);
    }

    public void changeVersion(String version) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    private <T> T call(Function<? super JpsMavenRepositoryLibraryDescriptor, ? extends T> method, T defaultValue) {
        JpsMavenRepositoryLibraryDescriptor descriptor = this.myDescriptor;
        return descriptor != null ? method.apply((JpsMavenRepositoryLibraryDescriptor)descriptor) : defaultValue;
    }

    @Transient
    public List<String> getExcludedDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getExcludedDependencies, Collections.emptyList());
    }

    public void setExcludedDependencies(List<String> dependencyMavenIds) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), this.isIncludeTransitiveDependencies(), dependencyMavenIds);
    }

    @XCollection(propertyElementName="exclude", elementName="dependency", valueAttributeName="maven-id")
    public List<String> getExcludedDependenciesBean() {
        return this.myDescriptor != null ? new ArrayList(this.myDescriptor.getExcludedDependencies()) : new ArrayList();
    }

    public void setExcludedDependenciesBean(List<String> dependencyMavenIds) {
        this.setExcludedDependencies(dependencyMavenIds);
    }

    @NotNull
    public JpsMavenRepositoryLibraryDescriptor getRepositoryLibraryDescriptor() {
        return this.myDescriptor != null ? this.myDescriptor : new JpsMavenRepositoryLibraryDescriptor(null, true, Collections.emptyList());
    }
}

