/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);
    private static final String QUOT = "&quot;";

    @Nullable
    public static Integer parseInteger(String text) {
        try {
            if (text.startsWith(HEX_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text.substring(2), 4, 32);
                return (int)value;
            }
            if (text.startsWith(BIN_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text.substring(2), 1, 32);
                return (int)value;
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                long value = PsiLiteralUtil.parseDigits(text, 3, 32);
                return (int)value;
            }
            return PsiLiteralUtil.parseIntegerNoPrefix(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer parseIntegerNoPrefix(String text) {
        long l = Long.parseLong(text, 10);
        if (text.equals(_2_IN_31) || l == (long)((int)l)) {
            return (int)l;
        }
        return null;
    }

    @Nullable
    public static Long parseLong(String text) {
        if (StringUtil.endsWithChar((CharSequence)text, (char)'L') || StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            if (text.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 4, 64);
            }
            if (text.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                return PsiLiteralUtil.parseDigits(text, 3, 64);
            }
            if (_2_IN_63.equals(text)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text) {
        try {
            return Float.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @NotNull
    public static String stringForCharLiteral(@NotNull String charLiteral) {
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            return "\"'\"";
        }
        return '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
    }

    @NotNull
    public static String charLiteralForCharString(@NotNull String text) {
        int length = text.length();
        if (length <= 1) {
            return text;
        }
        String character = text.substring(1, length - 1);
        String charLiteral = "'".equals(character) ? "'\\''" : ("\\\"".equals(character) ? "'\"'" : '\'' + character + '\'');
        return charLiteral;
    }

    public static boolean isUnsafeLiteral(PsiLiteralExpression expression) {
        PsiElement literal = expression.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type = ((PsiJavaToken)literal).getTokenType();
        return (type == JavaTokenType.CHARACTER_LITERAL || type == JavaTokenType.STRING_LITERAL) && expression.getValue() == null;
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s) {
        return PsiLiteralUtil.escapeTextBlockCharacters(s, false, true, true);
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s, boolean escapeStartQuote, boolean escapeEndQuote, boolean escapeSpacesInTheEnd) {
        int i = 0;
        int length = s.length();
        StringBuilder result = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseQuotes(i, s, result, escapeStartQuote, escapeEndQuote);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseSpaces(i, s, result, escapeSpacesInTheEnd);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseBackSlashes(i, s, result);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            result.append(s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static int parseQuotes(int start, @NotNull String s, @NotNull StringBuilder result, boolean escapeStartQuote, boolean escapeEndQuote) {
        char c = s.charAt(start);
        if (c != '\"') {
            return -1;
        }
        int nQuotes = 1;
        int i = start;
        while (true) {
            int nextIdx;
            int n = nextIdx = i + 1 >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i + 1);
            if (nextIdx == -1) {
                nextIdx = i + 1;
            }
            if (nextIdx >= s.length() || s.charAt(nextIdx) != '\"') break;
            ++nQuotes;
            i = nextIdx;
        }
        for (int q = 0; q < nQuotes; ++q) {
            if (q == 0 && start == 0 && escapeStartQuote || q % 3 == 2 || q == nQuotes - 1 && i + 1 == s.length() && escapeEndQuote) {
                result.append("\\\"");
                continue;
            }
            result.append('\"');
        }
        return i + 1;
    }

    private static int parseSpaces(int start, @NotNull String s, @NotNull StringBuilder result, boolean escapeSpacesInTheEnd) {
        int nextIdx;
        int i;
        char c = s.charAt(start);
        if (c != ' ') {
            return -1;
        }
        int nSpaces = 0;
        for (i = start; i < s.length() && s.charAt(i) == ' '; ++i) {
            ++nSpaces;
        }
        if (i >= s.length() && escapeSpacesInTheEnd) {
            result.append(StringUtil.repeat((String)" ", (int)(nSpaces - 1))).append("\\s");
            return i;
        }
        int n = nextIdx = i >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i);
        if (nextIdx != -1 && nextIdx < s.length() && s.charAt(nextIdx) == 'n') {
            result.append(StringUtil.repeat((String)" ", (int)(nSpaces - 1))).append("\\s");
            return i;
        }
        result.append(StringUtil.repeatSymbol((char)' ', (int)nSpaces));
        return i;
    }

    private static int parseBackSlashes(int start, @NotNull String s, @NotNull StringBuilder result) {
        int nextIdx;
        int i = PsiLiteralUtil.parseBackSlash(s, start);
        if (i == -1) {
            return -1;
        }
        int prev = start;
        int nSlashes = 1;
        while (i < s.length() && (nextIdx = PsiLiteralUtil.parseBackSlash(s, i)) != -1) {
            result.append(s, prev, i);
            prev = i;
            i = nextIdx;
            ++nSlashes;
        }
        if (i >= s.length()) {
            result.append(s, prev, s.length());
        } else if (nSlashes % 2 == 0) {
            result.append(s, prev, i);
        } else {
            char next = s.charAt(i);
            if (next == 'n') {
                result.append('\n');
            } else {
                if (next == '\"') {
                    return i;
                }
                result.append(s, prev, i).append(next);
            }
            return i + 1;
        }
        return i;
    }

    @NotNull
    public static String escapeBackSlashesInTextBlock(@NotNull String str) {
        int i = 0;
        int length = str.length();
        StringBuilder result = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseBackSlash(str, i);
            if (nextIdx != -1) {
                result.append("\\\\");
                i = nextIdx;
                continue;
            }
            result.append(str.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static int parseBackSlash(@NotNull String str, int idx) {
        char c = str.charAt(idx);
        if (c != '\\') {
            return -1;
        }
        int nextIdx = PsiLiteralUtil.parseEscapedBackSlash(str, idx);
        return nextIdx > 0 ? nextIdx : idx + 1;
    }

    private static int parseEscapedBackSlash(@NotNull String str, int idx) {
        int next = idx + 1;
        if (next >= str.length() || str.charAt(next) != 'u') {
            return -1;
        }
        while (str.charAt(next) == 'u') {
            ++next;
        }
        if (next + 3 >= str.length()) {
            return -1;
        }
        try {
            int code = Integer.parseInt(str.substring(next, next + 4), 16);
            if (code == 92) {
                return next + 4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String @Nullable [] getTextBlockLines(PsiLiteralExpression expression) {
        char c;
        if (!expression.isTextBlock()) {
            return null;
        }
        String rawText = expression.getText();
        if (rawText.length() < 7 || !rawText.endsWith("\"\"\"")) {
            return null;
        }
        int start = 3;
        while ((c = rawText.charAt(start++)) != '\n') {
            if (Character.isWhitespace(c) && start != rawText.length()) continue;
            return null;
        }
        return rawText.substring(start, rawText.length() - 3).split("\n", -1);
    }

    public static int getTextBlockIndent(PsiLiteralExpression expression) {
        String[] lines = PsiLiteralUtil.getTextBlockLines(expression);
        if (lines == null) {
            return -1;
        }
        return PsiLiteralUtil.getTextBlockIndent(lines);
    }

    public static int getTextBlockIndent(String @NotNull [] lines) {
        return PsiLiteralUtil.getTextBlockIndent(lines, false, false);
    }

    public static int getTextBlockIndent(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        int prefix = Integer.MAX_VALUE;
        for (int i = 0; i < lines.length && prefix != 0; ++i) {
            int indent;
            String line = lines[i];
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent == line.length() && (i < lines.length - 1 || ignoreLastLine)) {
                if (preserveContent) continue;
                lines[i] = "";
                continue;
            }
            if (indent >= prefix) continue;
            prefix = indent;
        }
        return prefix;
    }

    @Nullable
    public static String getStringLiteralContent(PsiLiteralExpression expression) {
        String text = expression.getText();
        int textLength = text.length();
        if (textLength > 1 && text.charAt(0) == '\"' && text.charAt(textLength - 1) == '\"') {
            return text.substring(1, textLength - 1);
        }
        if (textLength > QUOT.length() && text.startsWith(QUOT) && text.endsWith(QUOT)) {
            return text.substring(QUOT.length(), textLength - QUOT.length());
        }
        return null;
    }

    @Nullable
    public static String getTextBlockText(PsiLiteralExpression expression) {
        String[] lines = PsiLiteralUtil.getTextBlockLines(expression);
        if (lines == null) {
            return null;
        }
        int prefix = PsiLiteralUtil.getTextBlockIndent(lines);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0) {
                sb.append(PsiLiteralUtil.trimTrailingWhitespace(line.substring(prefix)));
            }
            if (i >= lines.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    private static String trimTrailingWhitespace(@NotNull String line) {
        int index;
        for (index = line.length() - 1; index >= 0 && Character.isWhitespace(line.charAt(index)); --index) {
        }
        if (index >= 0 && index < line.length() - 1 && line.charAt(index) == '\\') {
            ++index;
        }
        return line.substring(0, index + 1);
    }

    @Nullable
    public static TextRange mapBackStringRange(@NotNull String text, int from, int to) {
        if (from > to || to < 0) {
            return null;
        }
        if (text.length() < 2 || !text.startsWith("\"") || !text.endsWith("\"")) {
            return null;
        }
        if (text.indexOf(92) == -1) {
            return new TextRange(from + 1, to + 1);
        }
        text = text.substring(1, text.length() - 1);
        int charsSoFar = 0;
        int mappedFrom = -1;
        int i = 0;
        while (i != -1) {
            if (charsSoFar == from) {
                mappedFrom = i;
            }
            if (charsSoFar == to) {
                return new TextRange(mappedFrom + 1, i + 1);
            }
            ++charsSoFar;
            i = PsiLiteralUtil.getCharEndIndex(text, i);
        }
        return null;
    }

    @Nullable
    public static TextRange mapBackTextBlockRange(@NotNull String text, int from, int to, int indent) {
        if (from > to || to < 0) {
            return null;
        }
        TextBlockModel model = TextBlockModel.create(text, indent);
        if (model == null) {
            return null;
        }
        return model.mapTextBlockRangeBack(from, to);
    }

    private static int getCharEndIndex(@NotNull String line, int i) {
        char c;
        if (i >= line.length()) {
            return -1;
        }
        if ((c = line.charAt(i++)) == '\\') {
            char c1;
            if ((c1 = line.charAt(i++)) == 'u') {
                while (i < line.length() && line.charAt(i) == 'u') {
                    ++i;
                }
                i += 4;
            } else if (c1 >= '0' && c1 <= '7') {
                char c2;
                char c3 = c2 = i < line.length() ? line.charAt(i) : (char)'\u0000';
                if (c2 >= '0' && c2 <= '7') {
                    char c32;
                    char c4 = c32 = ++i < line.length() ? line.charAt(i) : (char)'\u0000';
                    if (c32 >= '0' && c32 <= '7' && c1 <= '3') {
                        ++i;
                    }
                }
            }
        }
        return i;
    }

    private static class TextBlockModel {
        private final String[] lines;
        private final int indent;
        private final int startPrefixLength;

        private TextBlockModel(String[] lines, int indent, int startPrefixLength) {
            this.lines = lines;
            this.indent = indent;
            this.startPrefixLength = startPrefixLength;
        }

        @Nullable
        private TextRange mapTextBlockRangeBack(int from, int to) {
            int curOffset = this.startPrefixLength;
            int charsSoFar = 0;
            int mappedFrom = -1;
            for (int i = 0; i < this.lines.length; ++i) {
                String line = this.lines[i];
                int linePrefixLength = TextBlockModel.findLinePrefixLength(line, this.indent);
                line = line.substring(linePrefixLength);
                boolean isLastLine = i == this.lines.length - 1;
                int lineSuffixLength = TextBlockModel.findLineSuffixLength(line, isLastLine);
                line = line.substring(0, line.length() - lineSuffixLength);
                if (!isLastLine) {
                    line = line + '\n';
                }
                curOffset += linePrefixLength;
                int nextIdx = 0;
                while (true) {
                    if (from == charsSoFar) {
                        mappedFrom = curOffset + nextIdx;
                    }
                    if (to == charsSoFar) {
                        return new TextRange(mappedFrom, curOffset + nextIdx);
                    }
                    int charIdx = nextIdx;
                    if ((nextIdx = PsiLiteralUtil.getCharEndIndex(line, charIdx)) == -1) break;
                    ++charsSoFar;
                    if (nextIdx != line.length()) continue;
                    curOffset += lineSuffixLength;
                }
                curOffset += line.length();
            }
            return null;
        }

        private static int findLinePrefixLength(@NotNull String line, int indent) {
            boolean isBlankLine = line.chars().allMatch(Character::isWhitespace);
            return isBlankLine ? line.length() : indent;
        }

        private static int findLineSuffixLength(@NotNull String line, boolean isLastLine) {
            int lastIdx;
            if (isLastLine) {
                return 0;
            }
            for (int i = lastIdx = line.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                return lastIdx - i;
            }
            return 0;
        }

        @Nullable
        private static TextBlockModel create(@NotNull String text, int indent) {
            if (text.length() < 7 || !text.startsWith("\"\"\"") || !text.endsWith("\"\"\"")) {
                return null;
            }
            int startPrefixLength = TextBlockModel.findStartPrefixLength(text);
            if (startPrefixLength == -1) {
                return null;
            }
            String[] lines = text.substring(startPrefixLength, text.length() - 3).split("\n", -1);
            return new TextBlockModel(lines, indent, startPrefixLength);
        }

        @Contract(pure=true)
        private static int findStartPrefixLength(@NotNull String text) {
            int lineBreakIdx = text.indexOf("\n");
            if (lineBreakIdx == -1) {
                return -1;
            }
            return lineBreakIdx + 1;
        }
    }
}

