/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        public int computeHashCode(MethodSignature signature) {
            return signature.hashCode();
        }

        public boolean equals(MethodSignature method1, MethodSignature method2) {
            return MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2) && MethodSignatureUtil.areErasedParametersEqual(method1, method2);
        }
    };

    private MethodSignatureUtil() {
    }

    public static boolean areOverrideEquivalent(PsiMethod method1, PsiMethod method2) {
        int typeParamsLength2;
        int typeParamsLength1 = method1.getTypeParameters().length;
        return (typeParamsLength1 == (typeParamsLength2 = method2.getTypeParameters().length) || typeParamsLength1 == 0 || typeParamsLength2 == 0) && MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areErasedParametersEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        Object[] erased1 = method1 instanceof MethodSignatureBase ? ((MethodSignatureBase)method1).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method1);
        Object[] erased2 = method2 instanceof MethodSignatureBase ? ((MethodSignatureBase)method2).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method2);
        return Arrays.equals(erased1, erased2);
    }

    public static PsiType @NotNull [] calcErasedParameterTypes(@NotNull MethodSignature signature) {
        PsiType[] parameterTypes = signature.getParameterTypes();
        if (parameterTypes.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = signature.getSubstitutor();
        PsiType[] erasedTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            erasedTypes[i] = TypeConversionUtil.erasure(parameterTypes[i], substitutor);
        }
        return erasedTypes;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor) {
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameterList, @NotNull PsiSubstitutor substitutor) {
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
    }

    public static boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        return MethodSignatureUtil.areSignaturesEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2)) || MethodSignatureUtil.checkSignaturesEqualInner(method2, method1, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method2, method1));
    }

    private static boolean checkSignaturesEqualInner(@NotNull MethodSignature subSignature, @NotNull MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!MethodSignatureUtil.areErasedParametersEqual(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal((Object)type1, (Object)(type2 = unifyingSubstitutor.substitute(superParameterTypes[i])))) continue;
            return false;
        }
        return true;
    }

    private static boolean areSignaturesEqualLightweight(@NotNull MethodSignature sig1, @NotNull MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        boolean isConstructor1 = sig1.isConstructor();
        if (isConstructor1 != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!(isConstructor1 && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod superMethodCandidate, @NotNull PsiMethod derivedMethod) {
        if (superMethodCandidate.hasModifierProperty("private")) {
            return false;
        }
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null || derivedClass == superClassCandidate) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass, @NotNull PsiClass superClass, @NotNull MethodSignature signature, boolean checkDeep) {
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods;
        String name = signature.getName();
        for (PsiMethod method : methods = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null && clazz != superClass) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod pattenMethod, boolean checkBases) {
        return MethodSignatureUtil.findMethodBySignature(aClass, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate.getSignature(substitutor);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasOverloads(@NotNull PsiMethod method) {
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    private static PsiMethod @NotNull [] getOverloads(@NotNull PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method};
        }
        return aClass.findMethodsByName(method.getName(), false);
    }

    public static boolean areParametersErasureEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1.getParameterList().getParametersCount() != method2.getParameterList().getParametersCount()) {
            return false;
        }
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(@NotNull MethodSignature signature1, @NotNull MethodSignature signature2) {
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature1, (Object)signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superMethodSignature) {
        PsiTypeParameter[] superTypeParameters;
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        if (methodTypeParameters.length != (superTypeParameters = superMethodSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result = superMethodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(methodTypeParameter.getProject());
            result = result.put(superTypeParameters[i], factory.createType(methodTypeParameter));
        }
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(result.substitute(superSuper)));
            }
            methodSupers.remove(PsiType.getJavaLangObject(methodTypeParameter.getManager(), methodTypeParameter.getResolveScope()));
            superSupers.remove(PsiType.getJavaLangObject(superTypeParameter.getManager(), superTypeParameter.getResolveScope()));
            if (methodSupers.equals(superSupers)) continue;
            return null;
        }
        return result;
    }

    @NotNull
    public static PsiSubstitutor combineSubstitutors(@NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters;
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            return substitutor2;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        for (PsiTypeParameter typeParameter : typeParameters = parameters1.toArray(PsiTypeParameter.EMPTY_ARRAY)) {
            PsiClass resolved;
            PsiType type = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type instanceof PsiClassType ? ((resolved = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type)) : substitutor2.substitute(type);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        return substitutor1;
    }

    public static PsiMethod @NotNull [] convertMethodSignaturesToMethods(@NotNull List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        PsiMethod[] methods = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods[i] = sameNameMethodList.get(i).getMethod();
        }
        return methods;
    }

    public static boolean isSubsignature(@NotNull MethodSignature superSignature, @NotNull MethodSignature subSignature) {
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i], superSignature.getSubstitutor());
            if (Comparing.equal((Object)type1, (Object)type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeSubstitutable(MethodSignature d1, MethodSignature d2, PsiType r1, PsiType r2) {
        if (PsiType.VOID.equals(r1)) {
            return PsiType.VOID.equals(r2);
        }
        if (r1 instanceof PsiPrimitiveType) {
            return r1.equals(r2);
        }
        if (r1 instanceof PsiClassType && r2 != null) {
            PsiSubstitutor adaptingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(d2, d1);
            if (adaptingSubstitutor != null && r2.isAssignableFrom(adaptingSubstitutor.substitute(r1))) {
                return true;
            }
            if (!MethodSignatureUtil.areSignaturesEqual(d1, d2)) {
                return r1.equals(TypeConversionUtil.erasure(r2));
            }
        }
        return Comparing.equal((Object)r1, (Object)r2);
    }
}

