/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import java.util.Locale;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum JavaElementKind {
    ABSTRACT_METHOD,
    ANNOTATION,
    CLASS,
    CONSTANT,
    CONSTRUCTOR,
    ENUM,
    ENUM_CONSTANT,
    EXPRESSION,
    FIELD,
    INITIALIZER,
    INTERFACE,
    LOCAL_VARIABLE,
    METHOD,
    MODULE,
    PACKAGE,
    PARAMETER,
    PATTERN_VARIABLE,
    RECORD,
    RECORD_COMPONENT,
    STATEMENT,
    UNKNOWN,
    VARIABLE;


    @Nls
    @NotNull
    public String subject() {
        return JavaPsiBundle.message("element." + this.name().toLowerCase(Locale.ROOT), 0);
    }

    @Nls
    @NotNull
    public String object() {
        return JavaPsiBundle.message("element." + this.name().toLowerCase(Locale.ROOT), 1);
    }

    public static JavaElementKind fromElement(@NotNull PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                return ENUM;
            }
            if (psiClass.isRecord()) {
                return RECORD;
            }
            if (psiClass.isAnnotationType()) {
                return ANNOTATION;
            }
            if (psiClass.isInterface()) {
                return INTERFACE;
            }
            return CLASS;
        }
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).isConstructor()) {
                return CONSTRUCTOR;
            }
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return ABSTRACT_METHOD;
            }
            return METHOD;
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (field instanceof PsiEnumConstant) {
                return ENUM_CONSTANT;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return CONSTANT;
            }
            return FIELD;
        }
        if (element instanceof PsiRecordComponent) {
            return RECORD_COMPONENT;
        }
        if (element instanceof PsiLocalVariable) {
            return LOCAL_VARIABLE;
        }
        if (element instanceof PsiPatternVariable) {
            return PATTERN_VARIABLE;
        }
        if (element instanceof PsiParameter) {
            return PARAMETER;
        }
        if (element instanceof PsiVariable) {
            return VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return PACKAGE;
        }
        if (element instanceof PsiJavaModule) {
            return MODULE;
        }
        if (element instanceof PsiClassInitializer) {
            return INITIALIZER;
        }
        if (element instanceof PsiStatement) {
            return STATEMENT;
        }
        if (element instanceof PsiExpression) {
            return EXPRESSION;
        }
        return UNKNOWN;
    }
}

