/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName) {
        int i = fqName.lastIndexOf(46);
        return i == -1 ? fqName : fqName.substring(i + 1);
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass, parentClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        Object2IntMap indices = (Object2IntMap)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            int index = 0;
            for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass.getQualifiedName() != null) continue;
                map.put((Object)aClass, ++index);
            }
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{containingClass});
        });
        return indices.getInt((Object)psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = !prefix.isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual((String)name, (String)aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual((String)name, (String)aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        return i == 0 ? "" : indexName.substring(0, i);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (parent != null) {
            return ClassUtil.findSubClass(name, parent, jvmCompatible);
        }
        PsiClass result = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent, boolean jvmCompatible) {
        PsiClass result;
        PsiClass psiClass = result = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent, jvmCompatible) : parent.findInnerClassByName(name, false);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent, jvmCompatible) : parent.findInnerClassByName(prefix, false);
            if (subClass == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass.getContainingClass() != null) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }

    public static String getAsmMethodSignature(PsiMethod method) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            signature.append(ClassUtil.getBinaryPresentation(param.getType()));
        }
        signature.append(")");
        signature.append(ClassUtil.getBinaryPresentation(Optional.ofNullable(method.getReturnType()).orElse(PsiType.VOID)));
        return signature.toString();
    }

    public static String getVMParametersMethodSignature(PsiMethod method) {
        return StringUtil.join((Object[])method.getParameterList().getParameters(), param -> {
            PsiType type = TypeConversionUtil.erasure(param.getType());
            return type != null ? type.accept(ClassUtil.createSignatureVisitor()) : "";
        }, (String)",");
    }

    private static PsiTypeVisitor<String> createSignatureVisitor() {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                return primitiveType.getCanonicalText();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return "";
                }
                return ClassUtil.getJVMClassName(aClass);
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                String typePresentation = componentType.accept(this);
                if (arrayType.getDeepComponentType() instanceof PsiPrimitiveType) {
                    return typePresentation + "[]";
                }
                if (componentType instanceof PsiClassType) {
                    typePresentation = "L" + typePresentation + ";";
                }
                return "[" + typePresentation;
            }
        };
    }

    @NotNull
    public static String getClassObjectPresentation(@NotNull PsiType psiType) {
        return ClassUtil.toBinary(psiType, false);
    }

    @NotNull
    public static String getBinaryPresentation(@NotNull PsiType psiType) {
        return ClassUtil.toBinary(psiType, true);
    }

    @NotNull
    private static String toBinary(@NotNull PsiType psiType, boolean slashes) {
        return Optional.of(psiType).map(type -> TypeConversionUtil.erasure(type)).map(type -> type.accept(ClassUtil.createBinarySignatureVisitor(slashes))).orElseGet(() -> psiType.getPresentableText());
    }

    private static PsiTypeVisitor<String> createBinarySignatureVisitor(final boolean slashes) {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                return primitiveType.getKind().getBinaryName();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return "";
                }
                String jvmClassName = ClassUtil.getJVMClassName(aClass);
                if (jvmClassName != null) {
                    jvmClassName = "L" + (slashes ? jvmClassName.replace(".", "/") : jvmClassName) + ";";
                }
                return jvmClassName;
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType) {
                return "[" + arrayType.getComponentType().accept(this);
            }
        };
    }
}

