/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperMethodsSearch
extends ExtensibleQueryFactory<MethodSignatureBackedByPsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.superMethodsSearch");
    private static final SuperMethodsSearch SUPER_METHODS_SEARCH_INSTANCE = new SuperMethodsSearch();

    private SuperMethodsSearch() {
    }

    @NotNull
    public static Query<MethodSignatureBackedByPsiMethod> search(@NotNull PsiMethod derivedMethod, @Nullable PsiClass psiClass, boolean checkBases, boolean allowStaticMethod) {
        return SuperMethodsSearch.search(new SearchParameters(derivedMethod, psiClass, checkBases, allowStaticMethod));
    }

    @NotNull
    public static Query<MethodSignatureBackedByPsiMethod> search(@NotNull SearchParameters parameters) {
        return SUPER_METHODS_SEARCH_INSTANCE.createUniqueResultsQuery(parameters, MethodSignatureUtil.METHOD_BASED_HASHING_STRATEGY);
    }

    public static class SearchParameters
    implements QueryParameters {
        private final PsiMethod myMethod;
        @Nullable
        private final PsiClass myClass;
        private final boolean myCheckBases;
        private final boolean myAllowStaticMethod;
        private final boolean myJlsOnly;

        public SearchParameters(@NotNull PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod) {
            this(method, aClass, checkBases, allowStaticMethod, false);
        }

        public SearchParameters(@NotNull PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod, boolean jlsOnly) {
            this.myCheckBases = checkBases;
            this.myClass = aClass;
            this.myMethod = method;
            this.myAllowStaticMethod = allowStaticMethod;
            this.myJlsOnly = jlsOnly;
        }

        @Nullable
        public Project getProject() {
            return this.myMethod.getProject();
        }

        public boolean isQueryValid() {
            return this.myMethod.isValid() && (this.myClass == null || this.myClass.isValid());
        }

        public final boolean isCheckBases() {
            return this.myCheckBases;
        }

        @NotNull
        public final PsiMethod getMethod() {
            return this.myMethod;
        }

        @Nullable
        public final PsiClass getPsiClass() {
            return this.myClass;
        }

        public final boolean isAllowStaticMethod() {
            return this.myAllowStaticMethod;
        }

        public boolean isJlsOnly() {
            return this.myJlsOnly;
        }
    }
}

