/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public final class AllClassesSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiClass, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.allClassesSearch");
    public static final AllClassesSearch INSTANCE = new AllClassesSearch();

    private AllClassesSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchScope scope, @NotNull Project project) {
        return INSTANCE.createQuery(new SearchParameters(scope, project));
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchScope scope, @NotNull Project project, @NotNull Condition<? super String> shortNameCondition) {
        return INSTANCE.createQuery(new SearchParameters(scope, project, shortNameCondition));
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final Project myProject;
        private final Condition<? super String> myShortNameCondition;

        public SearchParameters(@NotNull SearchScope scope, @NotNull Project project) {
            this(scope, project, (Condition<? super String>)Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull SearchScope scope, @NotNull Project project, @NotNull Condition<? super String> shortNameCondition) {
            this.myScope = scope;
            this.myProject = project;
            this.myShortNameCondition = shortNameCondition;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        public boolean nameMatches(@NotNull String name) {
            return this.myShortNameCondition.value((Object)name);
        }
    }
}

