/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CandidateInfo
implements JavaResolveResult {
    public static final CandidateInfo[] EMPTY_ARRAY = new CandidateInfo[0];
    public static final JavaResolveResult[] RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE = new JavaResolveResult[]{new CandidateInfo(PsiUtilCore.NULL_PSI_ELEMENT, PsiSubstitutor.EMPTY, Boolean.TRUE, false, null, null, null, true)};
    private final PsiElement myPlace;
    private final PsiClass myAccessClass;
    private final PsiElement myCandidate;
    private final boolean myStaticsProblem;
    protected final PsiSubstitutor mySubstitutor;
    private final PsiElement myCurrentFileResolveContext;
    private final boolean myPackagePrefixPackageReference;
    private Boolean myAccessible;

    private CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, Boolean accessible, boolean staticsProblem, PsiElement currFileContext, PsiElement place, PsiClass accessClass, boolean packagePrefixPackageReference) {
        this.myCandidate = candidate;
        this.myAccessible = accessible;
        this.myStaticsProblem = staticsProblem;
        this.mySubstitutor = substitutor;
        this.myCurrentFileResolveContext = currFileContext;
        this.myAccessClass = accessClass;
        this.myPlace = place;
        this.myPackagePrefixPackageReference = packagePrefixPackageReference;
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement currFileContext) {
        this(candidate, substitutor, !accessProblem, staticsProblem, currFileContext, null, null, false);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem) {
        this(candidate, substitutor, accessProblem, staticsProblem, null);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, PsiElement place, PsiClass accessClass, boolean staticsProblem, PsiElement currFileContext) {
        this(candidate, substitutor, null, staticsProblem, currFileContext, place, accessClass, false);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, PsiElement place, boolean staticsProblem) {
        this(candidate, substitutor, place, null, staticsProblem, null);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor) {
        this(candidate, substitutor, null, null, false, null);
    }

    public CandidateInfo(@NotNull CandidateInfo ci, @NotNull PsiSubstitutor newSubstitutor) {
        this(ci.myCandidate, newSubstitutor, ci.myAccessible, ci.myStaticsProblem, ci.myCurrentFileResolveContext, ci.myPlace, null, false);
    }

    public boolean isValidResult() {
        return this.isAccessible() && this.isStaticsScopeCorrect();
    }

    @Override
    public boolean isPackagePrefixPackageReference() {
        return this.myPackagePrefixPackageReference;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myCandidate;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    public boolean isAccessible() {
        Boolean accessible = this.myAccessible;
        if (accessible == null) {
            accessible = true;
            if (this.myPlace != null) {
                PsiResolveHelper helper = JavaPsiFacade.getInstance(this.myPlace.getProject()).getResolveHelper();
                if (this.myCandidate instanceof PsiMember) {
                    PsiMember member = (PsiMember)this.myCandidate;
                    accessible = helper.isAccessible(member, member.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileResolveContext);
                    if (accessible.booleanValue() && member.hasModifierProperty("private") && this.myPlace instanceof PsiReferenceExpression && JavaVersionService.getInstance().isAtLeast(this.myPlace, JavaSdkVersion.JDK_1_7)) {
                        accessible = !this.isAccessedThroughTypeParameterBound();
                    }
                } else if (this.myCandidate instanceof PsiPackage) {
                    accessible = helper.isAccessible((PsiPackage)this.myCandidate, this.myPlace);
                }
            }
            this.myAccessible = accessible;
        }
        return accessible;
    }

    private boolean isAccessedThroughTypeParameterBound() {
        JavaResolveResult resolveResult;
        PsiElement element;
        PsiExpression qualifierExpression = ((PsiReferenceExpression)this.myPlace).getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression && (element = (resolveResult = ((PsiMethodCallExpression)qualifierExpression).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)element).getReturnType();
            PsiType substitutedReturnType = resolveResult.getSubstitutor().substitute(returnType);
            if (substitutedReturnType instanceof PsiCapturedWildcardType || substitutedReturnType instanceof PsiWildcardType) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStaticsScopeCorrect() {
        return !this.myStaticsProblem;
    }

    @Override
    public PsiElement getCurrentFileResolveScope() {
        return this.myCurrentFileResolveContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateInfo that = (CandidateInfo)o;
        if (this.myPackagePrefixPackageReference != that.myPackagePrefixPackageReference) {
            return false;
        }
        if (this.myStaticsProblem != that.myStaticsProblem) {
            return false;
        }
        if (!Objects.equals(this.myAccessClass, that.myAccessClass)) {
            return false;
        }
        if (this.isAccessible() != that.isAccessible()) {
            return false;
        }
        if (!this.myCandidate.equals(that.myCandidate)) {
            return false;
        }
        if (!Objects.equals(this.myCurrentFileResolveContext, that.myCurrentFileResolveContext)) {
            return false;
        }
        if (!Objects.equals(this.myPlace, that.myPlace)) {
            return false;
        }
        return this.mySubstitutor.equals(that.mySubstitutor);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myPlace);
        result = 31 * result + Objects.hashCode(this.myAccessClass);
        result = 31 * result + this.myCandidate.hashCode();
        result = 31 * result + (this.isAccessible() ? 1 : 0);
        result = 31 * result + (this.myStaticsProblem ? 1 : 0);
        result = 31 * result + this.mySubstitutor.hashCode();
        result = 31 * result + Objects.hashCode(this.myCurrentFileResolveContext);
        result = 31 * result + (this.myPackagePrefixPackageReference ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{element=" + this.myCandidate + ", substitutor=" + this.mySubstitutor + "}";
    }
}

