/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadLocalTypes {
    private static final RecursionGuard<ThreadLocalTypes> ourGuard = RecursionManager.createGuard((String)"ThreadLocalTypes");
    private final Map<PsiElement, PsiType> myMap = new HashMap<PsiElement, PsiType>();
    private final boolean myProhibitCaching;

    private ThreadLocalTypes(boolean prohibitCaching) {
        this.myProhibitCaching = prohibitCaching;
    }

    @Nullable
    public static PsiType getElementType(@NotNull PsiElement psi) {
        List stack = ourGuard.currentStack();
        for (int i = stack.size() - 1; i >= 0; --i) {
            ThreadLocalTypes types = (ThreadLocalTypes)stack.get(i);
            PsiType type = types.myMap.get(psi);
            if (type == null) continue;
            if (types.myProhibitCaching) {
                ourGuard.prohibitResultCaching((Object)types);
            }
            return type;
        }
        return null;
    }

    public static boolean hasBindingFor(@NotNull PsiElement psi) {
        List stack = ourGuard.currentStack();
        for (int i = stack.size() - 1; i >= 0; --i) {
            ThreadLocalTypes types = (ThreadLocalTypes)stack.get(i);
            if (!types.myMap.containsKey(psi)) continue;
            if (types.myProhibitCaching) {
                ourGuard.prohibitResultCaching((Object)types);
            }
            return true;
        }
        return false;
    }

    public static <T> T performWithTypes(@NotNull Function<ThreadLocalTypes, T> action) {
        return ThreadLocalTypes.performWithTypes(action, true);
    }

    public static <T> T performWithTypes(@NotNull Function<ThreadLocalTypes, T> action, boolean prohibitCaching) {
        ThreadLocalTypes types = new ThreadLocalTypes(prohibitCaching);
        return (T)ourGuard.doPreventingRecursion((Object)types, false, () -> action.apply(types));
    }

    public void forceType(@NotNull PsiElement psi, @Nullable PsiType type) {
        this.myMap.put(psi, type);
    }
}

