/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementFinder {
    public static final ProjectExtensionPointName<PsiElementFinder> EP = new ProjectExtensionPointName("com.intellij.java.elementFinder");
    @Deprecated
    public static final ExtensionPointName<PsiElementFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.elementFinder");

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

    public abstract PsiClass @NotNull [] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public Condition<PsiClass> getClassesFilter(@NotNull GlobalSearchScope scope) {
        return null;
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return null;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
    }

    @NotNull
    protected static Set<String> getClassNames(PsiClass @NotNull [] classes) {
        if (classes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull(names, (Object)aClass.getName());
        }
        return names;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer) {
        return this.processPackageDirectories(psiPackage, scope, consumer, false);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        return true;
    }

    public PsiClass @NotNull [] getClasses(@Nullable String className, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses = this.getClasses(psiPackage, scope);
        if (className == null) {
            return allClasses;
        }
        return PsiElementFinder.filterByName(className, allClasses);
    }

    public static PsiClass @NotNull [] filterByName(@NotNull String className, PsiClass @NotNull [] classes) {
        if (classes.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (classes.length == 1) {
            return className.equals(classes[0].getName()) ? classes : PsiClass.EMPTY_ARRAY;
        }
        SmartList foundClasses = new SmartList();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        return foundClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : foundClasses.toArray(PsiClass.EMPTY_ARRAY);
    }
}

