/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJvmConversionHelper;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiClass
extends PsiNameIdentifierOwner,
PsiModifierListOwner,
PsiDocCommentOwner,
PsiTypeParameterListOwner,
PsiQualifiedNamedElement,
PsiTarget,
PomRenameableTarget<PsiElement>,
JvmClass {
    public static final PsiClass @NotNull [] EMPTY_ARRAY = new PsiClass[0];
    public static final ArrayFactory<PsiClass> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiClass[count];

    @Override
    @Nullable
    public String getQualifiedName();

    public boolean isInterface();

    public boolean isAnnotationType();

    public boolean isEnum();

    default public boolean isRecord() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList();

    @Nullable
    public PsiReferenceList getImplementsList();

    public PsiClassType @NotNull [] getExtendsListTypes();

    public PsiClassType @NotNull [] getImplementsListTypes();

    @Nullable
    @ApiStatus.Experimental
    default public PsiReferenceList getPermitsList() {
        return null;
    }

    @ApiStatus.Experimental
    default public PsiClassType @NotNull [] getPermitsListTypes() {
        PsiReferenceList permitsList = this.getPermitsList();
        if (permitsList != null) {
            return permitsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @Nullable
    public PsiClass getSuperClass();

    public PsiClass @NotNull [] getInterfaces();

    public PsiClass @NotNull [] getSupers();

    public PsiClassType @NotNull [] getSuperTypes();

    public PsiField @NotNull [] getFields();

    public PsiMethod @NotNull [] getMethods();

    public PsiMethod @NotNull [] getConstructors();

    public PsiClass @NotNull [] getInnerClasses();

    public PsiClassInitializer @NotNull [] getInitializers();

    public PsiField @NotNull [] getAllFields();

    public PsiMethod @NotNull [] getAllMethods();

    public PsiClass @NotNull [] getAllInnerClasses();

    @Nullable
    public PsiField findFieldByName(@NonNls String var1, boolean var2);

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod var1, boolean var2);

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod var1, boolean var2);

    @Override
    default public JvmMethod @NotNull [] findMethodsByName(@NotNull String methodName) {
        return this.findMethodsByName(methodName, false);
    }

    public PsiMethod @NotNull [] findMethodsByName(@NonNls String var1, boolean var2);

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String var1, boolean var2);

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors();

    @Nullable
    public PsiClass findInnerClassByName(@NonNls String var1, boolean var2);

    @Nullable
    public PsiElement getLBrace();

    @Nullable
    public PsiElement getRBrace();

    @Nullable
    public PsiIdentifier getNameIdentifier();

    public PsiElement getScope();

    public boolean isInheritor(@NotNull PsiClass var1, boolean var2);

    public boolean isInheritorDeep(PsiClass var1, @Nullable PsiClass var2);

    @Override
    @Nullable
    public PsiClass getContainingClass();

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures();

    public PsiElement setName(@NonNls @NotNull String var1) throws IncorrectOperationException;

    @Override
    @NotNull
    default public JvmClassKind getClassKind() {
        return PsiJvmConversionHelper.getJvmClassKind(this);
    }

    @Override
    @Nullable
    default public JvmReferenceType getSuperClassType() {
        return PsiJvmConversionHelper.getClassSuperType(this);
    }

    @Override
    default public JvmReferenceType @NotNull [] getInterfaceTypes() {
        return PsiJvmConversionHelper.getClassInterfaces(this);
    }

    default public PsiRecordComponent @NotNull [] getRecordComponents() {
        return PsiRecordComponent.EMPTY_ARRAY;
    }

    @Nullable
    default public PsiRecordHeader getRecordHeader() {
        return null;
    }
}

