/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmArrayType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PsiArrayType
extends PsiType.Stub
implements JvmArrayType {
    private final PsiType myComponentType;

    public PsiArrayType(@NotNull PsiType componentType) {
        this(componentType, TypeAnnotationProvider.EMPTY);
    }

    public PsiArrayType(@NotNull PsiType componentType, PsiAnnotation @NotNull [] annotations) {
        super(annotations);
        this.myComponentType = componentType;
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider) {
        super(provider);
        this.myComponentType = componentType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return this.getText(this.myComponentType.getPresentableText(annotated), "[]", false, annotated);
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(this.myComponentType.getCanonicalText(annotated), "[]", true, annotated);
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return this.getText(this.myComponentType.getInternalCanonicalText(), "[]", true, true);
    }

    protected String getText(@NotNull String prefix, @NotNull String suffix, boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        StringBuilder sb = new StringBuilder(prefix.length() + suffix.length());
        sb.append(prefix);
        if (annotated && (annotations = this.getAnnotations()).length != 0) {
            sb.append(' ');
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result = PsiArrayType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            result[i] = superTypes[i].createArrayType();
        }
        return result;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public PsiType getComponentType() {
        return this.myComponentType;
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiArrayType && this instanceof PsiEllipsisType == obj instanceof PsiEllipsisType && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }
}

