/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.ArrayFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiAnnotation
extends PsiAnnotationMemberValue,
JvmAnnotation {
    public static final PsiAnnotation[] EMPTY_ARRAY = new PsiAnnotation[0];
    public static final ArrayFactory<PsiAnnotation> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiAnnotation[count];
    @NonNls
    public static final String DEFAULT_REFERENCED_METHOD_NAME = "value";

    @NotNull
    public PsiAnnotationParameterList getParameterList();

    @Override
    @Nullable
    @NonNls
    public String getQualifiedName();

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement();

    @Nullable
    public PsiAnnotationMemberValue findAttributeValue(@Nullable @NonNls String var1);

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@Nullable @NonNls String var1);

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable @NonNls String var1, @Nullable T var2);

    @Nullable
    public PsiAnnotationOwner getOwner();

    @Nullable
    default public PsiClass resolveAnnotationType() {
        PsiElement declaration;
        PsiJavaCodeReferenceElement element = this.getNameReferenceElement();
        PsiElement psiElement = declaration = element == null ? null : element.resolve();
        if (!(declaration instanceof PsiClass) || !((PsiClass)declaration).isAnnotationType()) {
            return null;
        }
        return (PsiClass)declaration;
    }

    @Override
    @NotNull
    default public List<JvmAnnotationAttribute> getAttributes() {
        return Arrays.asList(this.getParameterList().getAttributes());
    }

    default public boolean hasQualifiedName(@NotNull String qualifiedName) {
        return qualifiedName.equals(this.getQualifiedName());
    }

    @Deprecated
    @Nullable
    default public PsiMetaData getMetaData() {
        return null;
    }

    public static enum TargetType {
        TYPE,
        FIELD,
        METHOD,
        PARAMETER,
        CONSTRUCTOR,
        LOCAL_VARIABLE,
        ANNOTATION_TYPE,
        PACKAGE,
        TYPE_USE,
        TYPE_PARAMETER,
        MODULE,
        RECORD_COMPONENT,
        UNKNOWN;

        public static final TargetType[] EMPTY_ARRAY;

        static {
            EMPTY_ARRAY = new TargetType[0];
        }
    }
}

