/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkVersionUtil {
    public static boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion expected) {
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion(element);
        return version == null || version.isAtLeast(expected);
    }

    @Contract(value="null, _ -> false")
    public static boolean isAtLeast(@Nullable Sdk jdk, @NotNull JavaSdkVersion expected) {
        JavaSdkVersion actual = JavaSdkVersionUtil.getJavaSdkVersion(jdk);
        return actual != null && actual.isAtLeast(expected);
    }

    public static JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null ? JavaSdkVersionUtil.getJavaSdkVersion(ModuleRootManager.getInstance((Module)module).getSdk()) : null;
    }

    public static JavaSdkVersion getJavaSdkVersion(@Nullable Sdk sdk) {
        if (sdk != null && sdk.getSdkType().getName().equals("Android SDK")) {
            return JavaSdkVersion.JDK_1_8;
        }
        if (sdk != null) {
            SdkTypeId sdkType = sdk.getSdkType();
            if (!(sdkType instanceof JavaSdk) && sdkType instanceof SdkType) {
                sdkType = ((SdkType)sdkType).getDependencyType();
            }
            if (sdkType instanceof JavaSdk) {
                return ((JavaSdk)sdkType).getVersion(sdk);
            }
        }
        return null;
    }

    @Nullable
    public static Sdk findJdkByVersion(@NotNull JavaSdkVersion version) {
        JavaSdk javaSdk = JavaSdk.getInstance();
        Sdk candidate = null;
        for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk)) {
            if (!javaSdk.isValidSdkHome(sdk.getHomePath())) continue;
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !v.isAtLeast(version)) continue;
            candidate = sdk;
        }
        return candidate;
    }
}

