/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionValidator {
    public static final ProjectExtensionPointName<InspectionValidator> EP_NAME = new ProjectExtensionPointName("com.intellij.compiler.inspectionValidator");
    private final String myId;
    private final String myDescription;
    private final String myProgressIndicatorText;
    private final Class<? extends LocalInspectionTool> @Nullable [] myInspectionToolClasses;
    @Nullable
    private final InspectionToolProvider myInspectionToolProvider;

    @Deprecated
    protected InspectionValidator(@NotNull @Nls String description, @NotNull @Nls String progressIndicatorText) {
        this(description, description, progressIndicatorText);
    }

    protected InspectionValidator(@NotNull @NonNls String id, @NotNull @Nls String description, @NotNull @Nls String progressIndicatorText) {
        this.myId = id;
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = null;
        this.myInspectionToolProvider = null;
    }

    public abstract boolean isAvailableOnScope(@NotNull CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        return Collections.emptyList();
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        if (this.myInspectionToolClasses != null) {
            return this.myInspectionToolClasses;
        }
        assert (this.myInspectionToolProvider != null) : "getInspectionToolClasses() must be overridden";
        return this.myInspectionToolProvider.getInspectionClasses();
    }

    public final String getId() {
        return this.myId;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile file) {
        return Collections.emptyMap();
    }
}

