/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.compiler.CompilerMessageCategory;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilationException
extends Exception {
    private final Collection<? extends Message> myMessages;

    public CompilationException(@NotNull String message, @NotNull Collection<? extends Message> messages) {
        super(message);
        this.myMessages = messages;
    }

    @NotNull
    public Collection<? extends Message> getMessages() {
        return this.myMessages;
    }

    public static class Message {
        @NotNull
        private final CompilerMessageCategory myCategory;
        @NotNull
        private final String myMessage;
        @Nullable
        private final String myUrl;
        private final int myLine;
        private final int myColumn;

        public Message(@NotNull CompilerMessageCategory category, @NotNull String message, @Nullable String url, int line, int column) {
            this.myCategory = category;
            this.myMessage = message;
            this.myUrl = url;
            this.myLine = line;
            this.myColumn = column;
        }

        @NotNull
        public CompilerMessageCategory getCategory() {
            return this.myCategory;
        }

        @NotNull
        public String getText() {
            return this.myMessage;
        }

        @Nullable
        public String getUrl() {
            return this.myUrl;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }
    }
}

