/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmElement;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.source.JvmDeclarationSearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class JvmLocalInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                JvmElementVisitor<Boolean> visitor = null;
                for (JvmElement jvmElement : JvmDeclarationSearch.getElementsByIdentifier(element)) {
                    if (visitor == null && (visitor = JvmLocalInspection.this.buildVisitor(holder.getProject(), (message, highlightType, fixes) -> holder.registerProblem(element, message, highlightType, fixes), isOnTheFly)) == null) {
                        return;
                    }
                    Boolean result = (Boolean)jvmElement.accept(visitor);
                    if (result != Boolean.TRUE) continue;
                    return;
                }
            }
        };
    }

    @Nullable
    protected abstract JvmElementVisitor<Boolean> buildVisitor(@NotNull Project var1, @NotNull HighlightSink var2, boolean var3);

    public static interface HighlightSink {
        default public void highlight(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String message, LocalQuickFix ... fixes) {
            this.highlight(message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }

        public void highlight(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String var1, @NotNull ProblemHighlightType var2, LocalQuickFix ... var3);
    }
}

