/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoryDescription {
    public static final RemoteRepositoryDescription MAVEN_CENTRAL = new RemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2");
    public static final RemoteRepositoryDescription JBOSS_COMMUNITY = new RemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/");
    public static final List<RemoteRepositoryDescription> DEFAULT_REPOSITORIES = ContainerUtil.immutableList((Object[])new RemoteRepositoryDescription[]{MAVEN_CENTRAL, JBOSS_COMMUNITY});
    private final String myId;
    private final String myName;
    private final String myUrl;
    private final boolean myAllowSnapshots;

    public RemoteRepositoryDescription(@NotNull String id, @NotNull String name, @NotNull String url) {
        this(id, name, url, true);
    }

    public RemoteRepositoryDescription(@NotNull String id, @NotNull String name, @NotNull String url, boolean allowSnapshots) {
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myAllowSnapshots = allowSnapshots;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public boolean isAllowSnapshots() {
        return this.myAllowSnapshots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryDescription that = (RemoteRepositoryDescription)o;
        return this.myAllowSnapshots == that.myAllowSnapshots && this.myId.equals(that.myId) && this.myName.equals(that.myName) && this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myName, this.myUrl, this.myAllowSnapshots);
    }

    public String toString() {
        return this.myId + ":" + this.myName + ":" + this.myUrl + " (snapshots=" + this.myAllowSnapshots + ")";
    }
}

