/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateToExceptionClassFilter
implements JvmExceptionOccurrenceFilter {
    @Override
    @Nullable
    public Filter.ResultItem applyFilter(@NotNull String exceptionClassName, @NotNull List<PsiClass> classes, int exceptionStartOffset) {
        PsiClass psiClass = classes.get(0);
        boolean inContent = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex().isInContent(psiClass.getContainingFile().getVirtualFile());
        HyperlinkInfo hyperlink = HyperlinkInfoFactory.getInstance().createMultiplePsiElementHyperlinkInfo(classes);
        String shortName = StringUtil.getShortName((String)exceptionClassName);
        return new Filter.Result(exceptionStartOffset + exceptionClassName.length() - shortName.length(), exceptionStartOffset + exceptionClassName.length(), hyperlink, !inContent);
    }
}

