/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionExFilterFactory
implements ExceptionFilterFactory {
    @Override
    @NotNull
    public Filter create(@NotNull GlobalSearchScope searchScope) {
        return new MyFilter(searchScope);
    }

    private static class MyFilter
    implements Filter,
    FilterMixin {
        private final ExceptionInfoCache myCache;

        MyFilter(@NotNull GlobalSearchScope scope) {
            this.myCache = new ExceptionInfoCache(scope);
        }

        public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
            return null;
        }

        public boolean shouldRunHeavy() {
            return true;
        }

        public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
            THashMap visited = new THashMap();
            ExceptionWorker.ParsedLine emptyInfo = new ExceptionWorker.ParsedLine(TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, null, -1);
            ExceptionWorker worker = new ExceptionWorker(this.myCache);
            for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
                ExceptionWorker.ParsedLine info;
                int lineEndOffset;
                int lineStartOffset = copiedFragment.getLineStartOffset(i);
                String lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset = copiedFragment.getLineEndOffset(i)));
                if (!lineText.contains(".java:") || (info = (ExceptionWorker.ParsedLine)visited.get(lineText)) == emptyInfo) continue;
                if (info == null) {
                    info = (ExceptionWorker.ParsedLine)ReadAction.compute(() -> DumbService.isDumb((Project)worker.getProject()) ? null : MyFilter.doParse(worker, lineEndOffset, lineText));
                    visited.put(lineText, info == null ? emptyInfo : info);
                    if (info == null) continue;
                }
                int off = startOffset + lineStartOffset;
                final Color color = UIUtil.getInactiveTextColor();
                consumer.consume((Object)new FilterMixin.AdditionalHighlight(off + info.classFqnRange.getStartOffset(), off + info.methodNameRange.getEndOffset()){

                    @NotNull
                    public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
                        return new TextAttributes(null, null, color, EffectType.BOLD_DOTTED_LINE, 0);
                    }
                });
            }
        }

        private static ExceptionWorker.ParsedLine doParse(@NotNull ExceptionWorker worker, int lineEndOffset, @NotNull String lineText) {
            PsiCodeBlock tryBlock;
            Filter.Result result = worker.execute(lineText, lineEndOffset);
            if (result == null) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = result.getHyperlinkInfo();
            if (!(hyperlinkInfo instanceof FileHyperlinkInfo)) {
                return null;
            }
            OpenFileDescriptor descriptor = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor();
            if (descriptor == null) {
                return null;
            }
            PsiFile psiFile = worker.getFile();
            if (psiFile == null || psiFile instanceof PsiCompiledFile) {
                return null;
            }
            int offset = descriptor.getOffset();
            if (offset <= 0) {
                return null;
            }
            PsiElement element = psiFile.findElementAt(offset);
            PsiTryStatement parent = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            PsiCodeBlock psiCodeBlock = tryBlock = parent != null ? parent.getTryBlock() : null;
            if (tryBlock == null || !tryBlock.getTextRange().contains(offset)) {
                return null;
            }
            return worker.getInfo();
        }

        @NotNull
        public String getUpdateMessage() {
            return "Highlighting try blocks...";
        }
    }
}

