/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class ArithmeticExceptionInfo
extends ExceptionInfo {
    ArithmeticExceptionInfo(int offset, String message) {
        super(offset, "java.lang.ArithmeticException", message);
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement e) {
        if (e instanceof PsiJavaToken && (e.textMatches((CharSequence)"%") || e.textMatches((CharSequence)"/")) && e.getParent() instanceof PsiPolyadicExpression) {
            PsiExpression prevOperand = (PsiExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)e, PsiExpression.class);
            PsiExpression nextOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)e, PsiExpression.class));
            if (prevOperand != null && TypeConversionUtil.isIntegralNumberType(prevOperand.getType()) && nextOperand != null && TypeConversionUtil.isIntegralNumberType(nextOperand.getType())) {
                Object value;
                while (nextOperand instanceof PsiUnaryExpression && ((PsiUnaryExpression)nextOperand).getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    nextOperand = PsiUtil.skipParenthesizedExprDown(((PsiUnaryExpression)nextOperand).getOperand());
                }
                if (nextOperand instanceof PsiLiteral && (value = ((PsiLiteral)((Object)nextOperand)).getValue()) instanceof Number && ((Number)value).longValue() != 0L) {
                    return null;
                }
                return nextOperand;
            }
        }
        return null;
    }
}

