/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.openapi.util.NullUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UExpression;

@ApiStatus.Internal
public interface UastCallMatcher {
    @Contract(value="null -> false")
    public boolean testCallExpression(@Nullable UCallExpression var1);

    @Contract(value="null -> false")
    public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression var1);

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static UastCallMatcher anyOf(final UastCallMatcher ... matchers) {
        return new UastCallMatcher(){

            @Override
            public boolean testCallExpression(@Nullable UCallExpression expression) {
                return Arrays.stream(matchers).anyMatch(matcher -> matcher.testCallExpression(expression));
            }

            @Override
            public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression expression) {
                return Arrays.stream(matchers).anyMatch(matcher -> matcher.testCallableReferenceExpression(expression));
            }
        };
    }

    public static class Builder {
        private String myMethodName;
        private String[] myArguments;
        private boolean myMatchArgumentTypeInheritors = true;
        private String myClassFqn;
        private String myReturnTypeClassFqn;

        @NotNull
        public Builder withMethodName(@NotNull String methodName) {
            this.myMethodName = methodName;
            return this;
        }

        @NotNull
        public Builder withClassFqn(@NotNull String classFqn) {
            this.myClassFqn = classFqn;
            return this;
        }

        @NotNull
        public Builder withReturnType(@NotNull String returnTypeClassFqn) {
            this.myReturnTypeClassFqn = returnTypeClassFqn;
            return this;
        }

        @NotNull
        public Builder withArgumentsCount(int argumentsCount) {
            this.myArguments = new String[argumentsCount];
            return this;
        }

        @NotNull
        public Builder withArgumentTypes(String ... arguments) {
            this.myArguments = arguments;
            return this;
        }

        @NotNull
        public Builder withMatchArgumentTypeInheritors(boolean matchArgumentTypeInheritors) {
            this.myMatchArgumentTypeInheritors = matchArgumentTypeInheritors;
            return this;
        }

        @NotNull
        public UastCallMatcher build() {
            if (!NullUtils.hasNotNull((Object[])new Object[]{this.myMethodName, this.myArguments, this.myClassFqn, this.myReturnTypeClassFqn})) {
                throw new IllegalStateException("At least one qualifier must be specified");
            }
            return new SimpleUastCallMatcher(this.myMethodName, this.myArguments, this.myMatchArgumentTypeInheritors, this.myClassFqn, this.myReturnTypeClassFqn);
        }
    }

    public static class SimpleUastCallMatcher
    implements UastCallMatcher {
        private final String myMethodName;
        private final String[] myArguments;
        private final boolean myMatchArgumentTypeInheritors;
        private final String myReturnTypeClassFqn;
        private final String myClassFqn;

        public SimpleUastCallMatcher(@Nullable String methodName, String @Nullable [] arguments, boolean matchArgumentTypeInheritors, @Nullable String classFqn, @Nullable String returnTypeClassFqn) {
            if (methodName == null && arguments == null && classFqn == null && returnTypeClassFqn == null) {
                throw new IllegalArgumentException("At least one qualifier must be specified");
            }
            this.myMethodName = methodName;
            this.myArguments = arguments;
            this.myMatchArgumentTypeInheritors = matchArgumentTypeInheritors;
            this.myClassFqn = classFqn;
            this.myReturnTypeClassFqn = returnTypeClassFqn;
        }

        @Override
        public boolean testCallExpression(@Nullable UCallExpression expression) {
            if (expression == null || expression.getMethodName() == null) {
                return false;
            }
            return this.methodNameMatches(expression) && this.classMatches(expression) && this.returnTypeMatches(expression) && this.argumentsMatch(expression);
        }

        @Override
        public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression expression) {
            if (expression == null) {
                return false;
            }
            return this.methodNameMatches(expression) && this.classMatches(expression) && this.returnTypeMatches(expression) && this.argumentsMatch(expression);
        }

        private boolean methodNameMatches(@NotNull UCallExpression expression) {
            return this.myMethodName == null || this.myMethodName.equals(expression.getMethodName());
        }

        private boolean methodNameMatches(@NotNull UCallableReferenceExpression expression) {
            return this.myMethodName == null || this.myMethodName.equals(expression.getCallableName());
        }

        private boolean classMatches(@NotNull UCallExpression expression) {
            return this.myClassFqn == null || this.myClassFqn.equals(AnalysisUastUtil.getExpressionReceiverTypeClassFqn(expression));
        }

        private boolean classMatches(@NotNull UCallableReferenceExpression expression) {
            return this.myClassFqn == null || this.myClassFqn.equals(AnalysisUastUtil.getCallableReferenceClassFqn(expression));
        }

        private boolean returnTypeMatches(@NotNull UCallExpression expression) {
            return this.myReturnTypeClassFqn == null || this.myReturnTypeClassFqn.equals(AnalysisUastUtil.getExpressionReturnTypePsiClassFqn(expression));
        }

        private boolean returnTypeMatches(@NotNull UCallableReferenceExpression expression) {
            if (this.myReturnTypeClassFqn == null) {
                return true;
            }
            PsiElement resolved = expression.resolve();
            if (!(resolved instanceof PsiMethod)) {
                return false;
            }
            return this.myReturnTypeClassFqn.equals(AnalysisUastUtil.getTypeClassFqn(((PsiMethod)resolved).getReturnType()));
        }

        private boolean argumentsMatch(@NotNull UCallExpression expression) {
            if (this.myArguments == null) {
                return true;
            }
            if (this.myArguments.length != expression.getValueArgumentCount()) {
                return false;
            }
            List<UExpression> argumentExpressions = null;
            for (int i = 0; i < this.myArguments.length; ++i) {
                UExpression argumentExpression;
                PsiType argumentExpressionType;
                String requiredArgumentTypeClassFqn = this.myArguments[i];
                if (requiredArgumentTypeClassFqn == null) continue;
                if (argumentExpressions == null) {
                    argumentExpressions = expression.getValueArguments();
                }
                if (requiredArgumentTypeClassFqn.equals(AnalysisUastUtil.getTypeClassFqn(argumentExpressionType = (argumentExpression = argumentExpressions.get(i)).getExpressionType()))) continue;
                if (!this.myMatchArgumentTypeInheritors) {
                    return false;
                }
                PsiClass argumentExpressionTypeClass = AnalysisUastUtil.getTypePsiClass(argumentExpressionType);
                if (argumentExpressionTypeClass == null) {
                    return false;
                }
                LinkedHashSet<PsiClass> expressionTypeSupers = InheritanceUtil.getSuperClasses(argumentExpressionTypeClass);
                boolean argumentMatches = false;
                for (PsiClass expressionTypeSuper : expressionTypeSupers) {
                    if (!requiredArgumentTypeClassFqn.equals(expressionTypeSuper.getQualifiedName())) continue;
                    argumentMatches = true;
                    break;
                }
                if (argumentMatches) continue;
                return false;
            }
            return true;
        }

        private boolean argumentsMatch(@NotNull UCallableReferenceExpression expression) {
            if (this.myArguments == null) {
                return true;
            }
            PsiElement resolved = expression.resolve();
            if (!(resolved instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)resolved;
            PsiParameterList parameterList = method.getParameterList();
            return this.myArguments.length == parameterList.getParametersCount();
        }
    }
}

