/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NlsCapitalizationUtil {
    public static boolean isCapitalizationSatisfied(String value, Nls.Capitalization capitalization) {
        if (StringUtil.isEmpty((String)value) || capitalization == Nls.Capitalization.NotSpecified) {
            return true;
        }
        value = value.replace("&", "");
        return capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)value).equals(value) : NlsCapitalizationUtil.checkSentenceCapitalization(value);
    }

    private static boolean checkSentenceCapitalization(@NotNull String value) {
        List words = StringUtil.split((String)value, (String)" ");
        int wordCount = words.size();
        if (wordCount == 0) {
            return true;
        }
        if (Character.isLetter(((String)words.get(0)).charAt(0)) && !NlsCapitalizationUtil.isCapitalizedWord((String)words.get(0))) {
            return false;
        }
        if (wordCount == 1) {
            return true;
        }
        int capitalized = 1;
        for (int i = 1; i < wordCount; ++i) {
            String word = (String)words.get(i);
            if (!NlsCapitalizationUtil.isCapitalizedWord(word) || word.length() == 1 || !Character.isLowerCase(word.charAt(1))) continue;
            ++capitalized;
        }
        if (capitalized == 1 && wordCount == 2) {
            return true;
        }
        double ratio = ((double)capitalized - 1.0) / (double)wordCount;
        return ratio <= 0.4;
    }

    private static boolean isCapitalizedWord(String word) {
        return !word.isEmpty() && Character.isLetter(word.charAt(0)) && Character.isUpperCase(word.charAt(0));
    }

    @NotNull
    public static String fixValue(String string, Nls.Capitalization capitalization) {
        return capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)string) : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)string));
    }
}

