/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaModuleSystemEx
extends JavaModuleSystem {
    @Nullable
    default public ErrorWithFixes checkAccess(@NotNull PsiClass target, @NotNull PsiElement place) {
        String packageName = PsiUtil.getPackageName(target);
        return packageName != null ? this.checkAccess(packageName, target.getContainingFile(), place) : null;
    }

    @Nullable
    public ErrorWithFixes checkAccess(@NotNull String var1, @Nullable PsiFile var2, @NotNull PsiElement var3);

    public static final class ErrorWithFixes {
        @NotNull
        @Nls
        public final String message;
        @NotNull
        public final List<IntentionAction> fixes;

        public ErrorWithFixes(@NotNull @Nls String message) {
            this(message, Collections.emptyList());
        }

        public ErrorWithFixes(@NotNull @Nls String message, @NotNull List<IntentionAction> fixes) {
            this.message = message;
            this.fixes = fixes;
        }
    }
}

