/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.core.JavaPsiBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class AnnotationsPanel {
    private final Project myProject;
    private String myDefaultAnnotation;
    private final Set<String> myDefaultAnnotations;
    private final JBTable myTable;
    private final JPanel myComponent;
    protected final DefaultTableModel myTableModel;

    public AnnotationsPanel(Project project, String name, String defaultAnnotation, List<String> annotations, List<String> defaultAnnotations, Set<String> checkedAnnotations, boolean showInstrumentationOptions, boolean showDefaultActions) {
        this.myProject = project;
        this.myDefaultAnnotation = defaultAnnotation;
        this.myDefaultAnnotations = new HashSet<String>(defaultAnnotations);
        this.myTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.myTableModel.setColumnCount(showInstrumentationOptions ? 2 : 1);
        for (String annotation : annotations) {
            this.addRow(annotation, checkedAnnotations.contains(annotation));
        }
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (value.equals(AnnotationsPanel.this.myDefaultAnnotation)) {
                    this.setIcon(AllIcons.Actions.Forward);
                } else {
                    this.setIcon(EmptyIcon.ICON_16);
                }
            }
        }, null));
        this.myTable = new JBTable((TableModel)this.myTableModel, (TableColumnModel)columnModel);
        if (showInstrumentationOptions) {
            columnModel.getColumn(0).setHeaderValue(JavaPsiBundle.message("node.annotation.tooltip", new Object[0]));
            TableColumn checkColumn = new TableColumn(1, 100, (TableCellRenderer)new BooleanTableCellRenderer(), (TableCellEditor)new BooleanTableCellEditor());
            columnModel.addColumn(checkColumn);
            checkColumn.setHeaderValue(" Instrument ");
            final TableCellRenderer defaultRenderer = this.myTable.getTableHeader().getDefaultRenderer();
            TableCellRenderer headerRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText(column == 1 ? JavaBundle.message("nullable.notnull.annotations.runtime.instrumentation.tooltip", new Object[0]) : null);
                    }
                    return component;
                }
            };
            this.myTable.getTableHeader().setDefaultRenderer(headerRenderer);
            checkColumn.setHeaderRenderer(headerRenderer);
            checkColumn.sizeWidthToFit();
        }
        AnActionButton selectButton = new AnActionButton(JavaBundle.messagePointer("action.AnActionButton.text.select.annotation.used.for.code.generation", new Object[0]), AllIcons.Actions.Checked){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                if (selectedValue == null) {
                    return;
                }
                AnnotationsPanel.this.myDefaultAnnotation = selectedValue;
                AnnotationsPanel.this.myTableModel.fireTableRowsUpdated(AnnotationsPanel.this.myTable.getSelectedRow(), AnnotationsPanel.this.myTable.getSelectedRow());
            }

            public void updateButton(@NotNull AnActionEvent e) {
                String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                e.getPresentation().setEnabled(selectedValue != null && !selectedValue.equals(AnnotationsPanel.this.myDefaultAnnotation));
            }
        };
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().setAddAction(b -> this.chooseAnnotation(name)).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                if (selectedValue == null) {
                    return;
                }
                if (AnnotationsPanel.this.myDefaultAnnotation.equals(selectedValue)) {
                    AnnotationsPanel.this.myDefaultAnnotation = (String)AnnotationsPanel.this.myTable.getValueAt(0, 0);
                }
                AnnotationsPanel.this.myTableModel.removeRow(AnnotationsPanel.this.myTable.getSelectedRow());
            }
        }).setRemoveActionUpdater(e -> !this.myDefaultAnnotations.contains(this.getSelectedAnnotation()));
        if (showDefaultActions) {
            toolbarDecorator.addExtraAction(selectButton);
        }
        JPanel panel = toolbarDecorator.createPanel();
        this.myComponent = new JPanel(new BorderLayout());
        this.myComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaBundle.message("nullable.notnull.annotations.panel.title", name), (boolean)false, (Insets)JBUI.insetsTop((int)10)));
        this.myComponent.add(panel);
        this.myComponent.setPreferredSize((Dimension)new JBDimension(this.myComponent.getPreferredSize().width, 200));
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        this.selectAnnotation(this.myDefaultAnnotation);
    }

    private void addRow(String annotation, boolean checked) {
        this.myTableModel.addRow(new Object[]{annotation, checked});
    }

    private Integer selectAnnotation(String annotation) {
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!annotation.equals(this.myTable.getValueAt(i, 0))) continue;
            this.myTable.setRowSelectionInterval(i, i);
            return i;
        }
        return null;
    }

    private String getSelectedAnnotation() {
        int selectedRow = this.myTable.getSelectedRow();
        return selectedRow < 0 ? null : (String)this.myTable.getValueAt(selectedRow, 0);
    }

    private void chooseAnnotation(String title) {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser("Choose " + title + " annotation", GlobalSearchScope.allScope((Project)this.myProject), new ClassFilter(){

            @Override
            public boolean isAccepted(PsiClass aClass) {
                return aClass.isAnnotationType();
            }
        }, null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        if (selected == null) {
            return;
        }
        String qualifiedName = selected.getQualifiedName();
        if (this.selectAnnotation(qualifiedName) == null) {
            this.addRow(qualifiedName, false);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    String getDefaultAnnotation() {
        return this.myDefaultAnnotation;
    }

    public String[] getAnnotations() {
        int size = this.myTable.getRowCount();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)this.myTable.getValueAt(i, 0);
        }
        return result;
    }

    List<String> getCheckedAnnotations() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.myTable.getValueAt(i, 1))) continue;
            result.add((String)this.myTable.getValueAt(i, 0));
        }
        return result;
    }
}

