/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTargetUtil {
    private static final Logger LOG = Logger.getInstance(AnnotationTargetUtil.class);
    public static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = ContainerUtil.immutableSet((Object[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE});
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] RECORD_COMPONENT_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.RECORD_COMPONENT, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] MODULE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.MODULE};

    public static PsiAnnotation.TargetType @NotNull [] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element = ((PsiModifierList)owner).getParent();
            if (element instanceof PsiPackageStatement) {
                return PACKAGE_TARGETS;
            }
            if (element instanceof PsiClass) {
                if (((PsiClass)element).getModifierList() != owner) {
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (((PsiClass)element).isAnnotationType()) {
                    return ANNOTATION_TARGETS;
                }
                return TYPE_TARGETS;
            }
            if (element instanceof PsiRecordComponent) {
                return RECORD_COMPONENT_TARGETS;
            }
            if (element instanceof PsiMethod) {
                if (((PsiMethod)element).isConstructor()) {
                    return CONSTRUCTOR_TARGETS;
                }
                return METHOD_TARGETS;
            }
            if (element instanceof PsiField) {
                return FIELD_TARGETS;
            }
            if (element instanceof PsiParameter) {
                PsiElement scope = element.getParent();
                if (scope instanceof PsiForeachStatement) {
                    return LOCAL_VARIABLE_TARGETS;
                }
                if (scope instanceof PsiParameterList && scope.getParent() instanceof PsiLambdaExpression && ((PsiParameter)element).getTypeElement() == null) {
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                return PARAMETER_TARGETS;
            }
            if (element instanceof PsiLocalVariable) {
                return LOCAL_VARIABLE_TARGETS;
            }
            if (element instanceof PsiReceiverParameter) {
                return TYPE_USE_TARGETS;
            }
            if (element instanceof PsiJavaModule) {
                return MODULE_TARGETS;
            }
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> extractRequiredAnnotationTargets(@Nullable PsiAnnotationMemberValue value) {
        if (value instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)value);
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value instanceof PsiArrayInitializerMemberValue) {
            EnumSet<PsiAnnotation.TargetType> targets = EnumSet.noneOf(PsiAnnotation.TargetType.class);
            for (PsiAnnotationMemberValue initializer : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer instanceof PsiReference) || (targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)initializer)) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(@NotNull PsiReference reference) {
        PsiElement field;
        String name;
        if (reference instanceof PsiJavaCodeReferenceElement && (name = ((PsiJavaCodeReferenceElement)reference).getReferenceName()) != null) {
            try {
                return PsiAnnotation.TargetType.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((field = reference.resolve()) instanceof PsiEnumConstant) {
            String name2 = ((PsiEnumConstant)field).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name2);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name2);
            }
        }
        return null;
    }

    public static boolean isTypeAnnotation(@NotNull PsiAnnotation element) {
        return AnnotationTargetUtil.findAnnotationTarget(element, PsiAnnotation.TargetType.TYPE_USE) == PsiAnnotation.TargetType.TYPE_USE;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiAnnotation annotation, PsiAnnotation.TargetType ... types) {
        PsiClass annotationType;
        if (types.length != 0 && (annotationType = annotation.resolveAnnotationType()) != null) {
            return AnnotationTargetUtil.findAnnotationTarget(annotationType, types);
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types) {
        Set<PsiAnnotation.TargetType> targets;
        if (types.length != 0 && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationType)) != null) {
            for (PsiAnnotation.TargetType type : types) {
                if (type == PsiAnnotation.TargetType.UNKNOWN || !targets.contains((Object)type)) continue;
                return type;
            }
            return null;
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType) {
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiModifierList modifierList = annotationType.getModifierList();
        if (modifierList == null) {
            return null;
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)modifierList, () -> CachedValueProvider.Result.create(AnnotationTargetUtil.calcAnnotationTargets(modifierList), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static Set<PsiAnnotation.TargetType> calcAnnotationTargets(PsiModifierList modifierList) {
        PsiAnnotation target = modifierList.findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return DEFAULT_TARGETS;
        }
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(target, null);
        if (attribute == null) {
            return null;
        }
        return AnnotationTargetUtil.extractRequiredAnnotationTargets(attribute.getDetachedValue());
    }

    @Nullable
    public static PsiAnnotationOwner getTarget(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotation) {
        PsiModifierList list = modifierListOwner.getModifierList();
        if (list == null) {
            return null;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance(modifierListOwner.getProject()).findClass(annotation, modifierListOwner.getResolveScope());
        if (annotationClass != null && AnnotationTargetUtil.findAnnotationTarget(annotationClass, PsiAnnotation.TargetType.TYPE_USE) != null && !(modifierListOwner instanceof PsiCompiledElement)) {
            PsiElement parent = list.getParent();
            PsiTypeElement type = null;
            if (parent instanceof PsiMethod) {
                type = ((PsiMethod)parent).getReturnTypeElement();
            } else if (parent instanceof PsiVariable) {
                type = ((PsiVariable)parent).getTypeElement();
            }
            if (type != null && !type.getType().equals(PsiType.VOID)) {
                return type;
            }
        }
        return list;
    }
}

