/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.CompositeDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.NamedPatternFilter;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.intellij.plugins.relaxNG.validation.XmlInstanceValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.nc.NameClass;

public class RngNsDescriptor
implements XmlNSDescriptorEx,
Validator {
    private final Map<QName, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private XmlFile myFile;
    private PsiElement myElement;
    private String myUrl;
    private DPattern myPattern;
    private PsiManager myManager;

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor desc;
        if (this.myPattern == null) {
            return null;
        }
        LinkedList<XmlTag> chain = new LinkedList<XmlTag>();
        for (XmlTag _tag = tag; _tag != null; _tag = _tag.getParentTag()) {
            chain.addFirst(_tag);
        }
        while ((desc = this.findRootDescriptor((XmlTag)chain.removeFirst())) == null && chain.size() > 0) {
        }
        if (desc != null) {
            XmlTag xmlTag;
            Iterator iterator = chain.iterator();
            while (iterator.hasNext() && (desc = desc.getElementDescriptor(xmlTag = (XmlTag)iterator.next(), xmlTag.getParentTag())) != null) {
            }
        }
        if (desc == null || desc instanceof AnyXmlElementDescriptor) {
            return this.findRootDescriptor(tag);
        }
        return desc;
    }

    private XmlElementDescriptor findRootDescriptor(XmlTag tag) {
        return this.getElementDescriptor(tag.getLocalName(), tag.getNamespace());
    }

    private XmlElementDescriptor findRootDescriptorInner(QName qName) {
        XmlElementDescriptor descriptor = this.findDescriptor(qName, (List<? extends DElementPattern>)ContainerUtil.findAll(ChildElementFinder.find(-1, this.myPattern), (Condition)NamedPatternFilter.INSTANCE));
        return descriptor != null ? descriptor : this.findDescriptor(qName, ChildElementFinder.find(this.myPattern));
    }

    public XmlElementDescriptor findDescriptor(XmlTag tag, List<? extends DElementPattern> list) {
        QName qName = new QName(tag.getNamespace(), tag.getLocalName());
        return this.findDescriptor(qName, list);
    }

    private XmlElementDescriptor findDescriptor(QName qName, List<? extends DElementPattern> list) {
        int max = -1;
        DElementPattern maxPattern = null;
        for (DElementPattern dElementPattern : list) {
            int spec;
            NameClass nameClass = dElementPattern.getName();
            if (!nameClass.contains(qName) || (spec = nameClass.containsSpecificity(qName)) <= max) continue;
            maxPattern = dElementPattern;
            max = spec;
        }
        List patterns = ContainerUtil.findAll(list, pattern -> {
            NameClass nameClass = pattern.getName();
            return nameClass.contains(qName);
        });
        if (maxPattern != null) {
            if (patterns.size() > 1) {
                return this.initDescriptor(new CompositeDescriptor(this, maxPattern, patterns));
            }
            return this.initDescriptor(new RngElementDescriptor(this, maxPattern));
        }
        return null;
    }

    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document) {
        if (this.myPattern == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        List<DElementPattern> list = ChildElementFinder.find(-1, this.myPattern);
        return this.convertElementDescriptors(list);
    }

    XmlElementDescriptor[] convertElementDescriptors(List<? extends DElementPattern> patterns) {
        patterns = ContainerUtil.findAll(patterns, (Condition)NamedPatternFilter.INSTANCE);
        LinkedHashMap name2patterns = new LinkedHashMap();
        for (DElementPattern pattern : patterns) {
            ProgressManager.checkCanceled();
            for (QName qName : pattern.getName().listNames()) {
                ArrayList<DElementPattern> dPatterns = (ArrayList<DElementPattern>)name2patterns.get(qName);
                if (dPatterns == null) {
                    dPatterns = new ArrayList<DElementPattern>();
                    name2patterns.put(qName, dPatterns);
                }
                if (dPatterns.contains(pattern)) continue;
                dPatterns.add(pattern);
            }
        }
        ArrayList<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();
        for (QName qName : name2patterns.keySet()) {
            List patternList;
            XmlElementDescriptor descriptor = this.findDescriptor(qName, (List<? extends DElementPattern>)(patternList = (List)name2patterns.get(qName)));
            if (descriptor == null) continue;
            result.add(descriptor);
        }
        return result.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    protected XmlElementDescriptor initDescriptor(@NotNull XmlElementDescriptor descriptor) {
        return descriptor;
    }

    @NotNull
    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public synchronized PsiElement getDeclaration() {
        PsiFile file;
        VirtualFile fileByUrl;
        if (!(this.myElement.isValid() && this.myFile.isValid() || this.myUrl == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(this.myUrl)) == null || !((file = this.myManager.findFile(fileByUrl)) instanceof XmlFile))) {
            this.init((PsiElement)((XmlFile)file).getDocument());
        }
        return this.myFile.isValid() ? this.myFile.getDocument() : null;
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @NonNls
    public String getName() {
        return this.getDescriptorFile().getName();
    }

    public Object @NotNull [] getDependencies() {
        if (this.myPattern != null) {
            if (DumbService.isDumb((Project)this.myElement.getProject())) {
                return new Object[]{ModificationTracker.EVER_CHANGED, ExternalResourceManager.getInstance()};
            }
            Object[] a = new Object[]{this.myElement, ExternalResourceManager.getInstance()};
            PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processForwardDependencies(this.myFile, (PsiElementProcessor<? super XmlFile>)processor);
            if (processor.getCollection().size() > 0) {
                return ArrayUtil.mergeArrays((Object[])a, (Object[])processor.toArray());
            }
            return a;
        }
        return new Object[]{ModificationTracker.EVER_CHANGED};
    }

    public synchronized void init(PsiElement element) {
        this.myElement = element;
        this.myFile = element instanceof XmlFile ? (XmlFile)element : (XmlFile)element.getContainingFile();
        this.myManager = this.myFile.getManager();
        VirtualFile file = this.myFile.getVirtualFile();
        if (file != null) {
            this.myUrl = file.getUrl();
        }
        this.myPattern = RngParser.getCachedPattern((PsiFile)this.getDescriptorFile(), RngParser.DEFAULT_HANDLER);
    }

    public void validate(@NotNull PsiElement context, @NotNull Validator.ValidationHost host) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)context, XmlDocument.class, (boolean)false);
        if (doc == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        if (!"http://relaxng.org/ns/structure/1.0".equals(rootTag.getNamespace())) {
            XmlInstanceValidator.doValidation(doc, host, this.getDescriptorFile());
        }
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        QName qName = new QName(namespace, localName);
        CachedValue cachedValue = this.myDescriptorsMap.get(qName);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
                XmlElementDescriptor descriptor = this.findRootDescriptorInner(qName);
                return descriptor != null ? new CachedValueProvider.Result((Object)descriptor, descriptor.getDependencies()) : new CachedValueProvider.Result(null, this.getDependencies());
            }, false);
            this.myDescriptorsMap.put(qName, (CachedValue<XmlElementDescriptor>)cachedValue);
        }
        return (XmlElementDescriptor)cachedValue.getValue();
    }
}

