/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CommonAnnotationHolder<C> {
    CommonAnnotationHolder() {
    }

    public static <T extends DomElement> CommonAnnotationHolder<T> create(DomElementAnnotationHolder holder) {
        return new DomHolderAdapter(holder);
    }

    public static <T extends PsiElement> CommonAnnotationHolder<T> create(AnnotationHolder holder) {
        return new HolderAdapter(holder);
    }

    public abstract void createAnnotation(@NotNull HighlightSeverity var1, @NotNull C var2, @Nullable String var3, @Nullable GutterIconRenderer var4);

    private static class HolderAdapter<T extends PsiElement>
    extends CommonAnnotationHolder<T> {
        private final AnnotationHolder myHolder;

        HolderAdapter(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void createAnnotation(@NotNull HighlightSeverity severity, @NotNull T element, @Nullable String message, @Nullable GutterIconRenderer renderer) {
            AnnotationBuilder builder;
            AnnotationBuilder annotationBuilder = builder = message == null ? this.myHolder.newSilentAnnotation(severity) : this.myHolder.newAnnotation(severity, message);
            if (renderer != null) {
                builder = builder.gutterIconRenderer(renderer);
            }
            builder.create();
        }
    }

    private static class DomHolderAdapter<T extends DomElement>
    extends CommonAnnotationHolder<T> {
        private final DomElementAnnotationHolder myHolder;

        DomHolderAdapter(DomElementAnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void createAnnotation(@NotNull HighlightSeverity severity, @NotNull DomElement element, String message, @Nullable GutterIconRenderer renderer) {
            Annotation annotation = this.myHolder.createAnnotation(element, severity, message);
            annotation.setTooltip(message);
            annotation.setGutterIconRenderer(renderer);
        }
    }
}

