/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.xml.util.XmlUtil;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncFileReference;
import org.intellij.plugins.relaxNG.compact.psi.impl.FollowFileHint;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.references.FileReferenceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RncFileReferenceImpl
extends RncElementImpl
implements RncFileReference {
    RncFileReferenceImpl(ASTNode node) {
        super(node);
    }

    public PsiReference @NotNull [] getReferences() {
        ASTNode literal = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (literal == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = literal.getText();
        FileReferenceSet set = new FileReferenceSet(s.substring(1, s.length() - 1), (PsiElement)this, this.getReferenceRange().getStartOffset(), null, true, false);
        return FileReferenceUtil.restrict(set, FileReferenceUtil.byType(RncFileType.getInstance()));
    }

    @Override
    public RncFile getReferencedFile() {
        PsiFile file;
        String href = this.getFileReference();
        if (href != null && (file = XmlUtil.findRelativeFile(href, (PsiElement)this.getContainingFile())) instanceof RncFile) {
            return (RncFile)file;
        }
        return null;
    }

    @Override
    @Nullable
    public String getFileReference() {
        ASTNode element = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (element == null) {
            return null;
        }
        String s = EscapeUtil.unescapeText(element);
        return s.substring(1, s.length() - 1);
    }

    @Override
    public TextRange getReferenceRange() {
        ASTNode literal = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (literal == null) {
            return TextRange.from((int)0, (int)0);
        }
        int startInElement = literal.getStartOffset() - this.getTextOffset() + 1;
        return TextRange.from((int)startInElement, (int)(literal.getTextLength() - 2));
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        FollowFileHint hint = (FollowFileHint)processor.getHint(FollowFileHint.KEY);
        RncFile file = this.getReferencedFile();
        if (file != null && hint != null && hint.doFollow(file)) {
            file.processDeclarations(processor, substitutor, lastParent, place);
        }
        return true;
    }
}

