/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.lang.BracePair;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RngCompactLanguage
extends Language {
    public static final String ID = "RELAX-NG";
    public static final RngCompactLanguage INSTANCE = new RngCompactLanguage();

    private RngCompactLanguage() {
        super(ID, new String[]{"application/relax-ng-compact-syntax"});
    }

    public static class MyDocumentationProvider
    implements DocumentationProvider {
        @Nullable
        public String generateDoc(PsiElement element, PsiElement originalElement) {
            if (element instanceof RncElement) {
                PsiElement comment = element.getPrevSibling();
                while (comment instanceof PsiWhiteSpace) {
                    comment = comment.getPrevSibling();
                }
                if (comment instanceof PsiComment) {
                    StringBuilder sb = new StringBuilder();
                    do {
                        sb.insert(0, EscapeUtil.unescapeText(comment).replaceAll("\n?##?", "") + "<br>");
                    } while ((comment = comment.getPrevSibling()) instanceof PsiComment);
                    if (element instanceof RncDefine) {
                        sb.insert(0, "Define: <b>" + ((RncDefine)element).getName() + "</b><br>");
                    }
                    return sb.toString();
                }
            }
            return null;
        }
    }

    public static class MyNamesValidator
    implements NamesValidator {
        public boolean isKeyword(@NotNull String name, Project project) {
            return RenameUtil.isKeyword(name);
        }

        public boolean isIdentifier(@NotNull String name, Project project) {
            return RenameUtil.isIdentifier(name);
        }
    }

    public static class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private BracePair[] myBracePairs;

        public BracePair @NotNull [] getPairs() {
            if (this.myBracePairs == null) {
                this.myBracePairs = new BracePair[]{new BracePair(RncTokenTypes.LBRACE, RncTokenTypes.RBRACE, true), new BracePair(RncTokenTypes.LPAREN, RncTokenTypes.RPAREN, false), new BracePair(RncTokenTypes.LBRACKET, RncTokenTypes.RBRACKET, false)};
            }
            return this.myBracePairs;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            return false;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }

    public static class MyCommenter
    implements Commenter {
        @Nullable
        public String getLineCommentPrefix() {
            return "#";
        }

        @Nullable
        public String getBlockCommentPrefix() {
            return null;
        }

        @Nullable
        public String getBlockCommentSuffix() {
            return null;
        }

        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        public String getCommentedBlockCommentSuffix() {
            return null;
        }
    }
}

