/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.google.gson.Gson;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCompatibilityData {
    private static final Map<String, Object> ourTagsCache = new HashMap<String, Object>();
    private static final Ref<Map> ourGlobalAttributesCache = new Ref();
    public static final String MATHML = "mathml";
    public static final String SVG = "svg";
    public static final String MATH = "math";

    @Nullable
    public static Map getTagData(@NotNull String namespace, @NotNull String tagName) {
        if (tagName.equals(MATH)) {
            namespace = MATHML;
        } else if (tagName.equals(SVG)) {
            namespace = SVG;
        }
        String key = tagName.equals("input") ? "input/text" : tagName;
        String cacheKey = namespace + key;
        if (!ourTagsCache.containsKey(cacheKey)) {
            URL resource = HtmlCompatibilityData.class.getResource("compatData" + (!namespace.isEmpty() ? "/" + namespace : "") + "/elements/" + key + ".json");
            if (resource == null) {
                return null;
            }
            try {
                Object data;
                Object json = new Gson().fromJson((Reader)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8), Object.class);
                Object tagHolder = ((Map)json).get(namespace.isEmpty() ? "html" : namespace);
                if (tagHolder == null) {
                    ourTagsCache.put(cacheKey, null);
                    return null;
                }
                Object elements = ((Map)tagHolder).get("elements");
                int subKey = key.indexOf("/");
                if (subKey > 0) {
                    Object element = ((Map)elements).get(key.substring(0, subKey));
                    data = ((Map)element).get(key.replace('/', '-'));
                } else {
                    data = ((Map)elements).get(key);
                }
                ourTagsCache.put(cacheKey, data);
            }
            catch (IOException e) {
                ourTagsCache.put(cacheKey, null);
                return null;
            }
        }
        return (Map)ourTagsCache.get(cacheKey);
    }

    @Nullable
    public static Map getTagData(@Nullable XmlTag tag) {
        String type;
        String key;
        if (tag == null) {
            return null;
        }
        String string = key = tag.isCaseSensitive() ? tag.getName() : StringUtil.toLowerCase((String)tag.getName());
        if ("input".equals(key) && (type = tag.getAttributeValue("type")) != null) {
            key = key + type;
        }
        return HtmlCompatibilityData.getTagData(HtmlCompatibilityData.getNamespace(tag), key);
    }

    private static String getNamespace(XmlTag tag) {
        for (XmlTag element = tag; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            String name;
            if (!(element instanceof XmlTag)) continue;
            String string = name = tag.isCaseSensitive() ? element.getName() : StringUtil.toLowerCase((String)element.getName());
            if (MATH.equals(name)) {
                return MATHML;
            }
            if (!SVG.equals(name)) continue;
            return SVG;
        }
        return "";
    }

    @Nullable
    public static Map getAttributeData(@Nullable XmlTag tag, String attributeName) {
        Object attributeData;
        Map data = HtmlCompatibilityData.getTagData(tag);
        if (data != null && (attributeData = data.get(attributeName)) != null) {
            return (Map)attributeData;
        }
        if (ourGlobalAttributesCache.get() == null) {
            Object json = new Gson().fromJson((Reader)new InputStreamReader(HtmlCompatibilityData.class.getResourceAsStream("compatData/global_attributes.json"), StandardCharsets.UTF_8), Object.class);
            Object html = ((Map)json).get("html");
            Object globalAttributes = ((Map)html).get("global_attributes");
            ourGlobalAttributesCache.set((Object)((Map)globalAttributes));
        }
        return (Map)((Map)ourGlobalAttributesCache.get()).get(attributeName);
    }
}

