/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlEntityRef;
import org.jetbrains.annotations.NotNull;

public class CheckDtdReferencesInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlElement(XmlElement element) {
                if (element instanceof XmlElementContentSpec || element instanceof XmlEntityRef) {
                    CheckDtdReferencesInspection.doCheckRefs(element, holder);
                }
            }
        };
    }

    private static void doCheckRefs(XmlElement element, ProblemsHolder holder) {
        for (PsiReference ref : element.getReferences()) {
            String image;
            ProgressManager.checkCanceled();
            if (!XmlHighlightVisitor.hasBadResolve(ref, true) || ref.getElement() instanceof XmlElementContentSpec && ((image = ref.getCanonicalText()).equals("-") || image.equals("O"))) continue;
            holder.registerProblem(ref);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }
}

