/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateXmlBlock
extends XmlBlock
implements IndentInheritingBlock {
    private final AbstractXmlTemplateFormattingModelBuilder myBuilder;
    private Indent myIndent;
    private static final List<Block> EMPTY_BLOCK_LIST = new ArrayList<Block>();

    public TemplateXmlBlock(AbstractXmlTemplateFormattingModelBuilder builder, ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy, indent, textRange);
        this.myBuilder = builder;
    }

    @Override
    @NotNull
    protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable TextRange range) {
        return this.myBuilder.createXmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, (TextRange)ObjectUtils.notNull((Object)range, (Object)child.getTextRange()));
    }

    @Override
    protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return this.myBuilder.createXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent);
    }

    @Override
    protected Indent getChildDefaultIndent() {
        Indent indent = super.getChildDefaultIndent();
        if (indent == null) {
            indent = Indent.getNoneIndent();
        }
        return indent;
    }

    protected List<Block> buildChildrenNoMerge() {
        return super.buildChildren();
    }

    @Override
    protected List<Block> buildChildren() {
        try {
            List<Block> childBlocks = this.patchTopLevelChildBlocks(this.buildChildrenNoMerge());
            return this.myBuilder.mergeWithTemplateBlocks(childBlocks, this.myXmlFormattingPolicy.getSettings(), this.myXmlFormattingPolicy, this.getChildDefaultIndent());
        }
        catch (FragmentedTemplateException fte) {
            return EMPTY_BLOCK_LIST;
        }
    }

    private List<Block> patchTopLevelChildBlocks(List<Block> originalBlocks) {
        if (this.myNode.getPsi() instanceof PsiFile) {
            ArrayList<Block> patchedBlocks = new ArrayList<Block>();
            for (Block block : originalBlocks) {
                if (block == originalBlocks.get(0) && block instanceof TemplateXmlBlock) {
                    patchedBlocks.addAll(((TemplateXmlBlock)block).buildChildrenNoMerge());
                    continue;
                }
                patchedBlocks.add(block);
            }
            return patchedBlocks;
        }
        return originalBlocks;
    }

    @Override
    public void setIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent != null ? this.myIndent : super.getIndent();
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child1 instanceof TemplateLanguageBlock && child2 instanceof TemplateLanguageBlock) {
            return ((TemplateLanguageBlock)child1).getSpacing((TemplateLanguageBlock)child2);
        }
        if (child1 instanceof TemplateLanguageBlock || child2 instanceof TemplateLanguageBlock) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    public boolean isTextContainingTemplateElements() {
        if (this.isTextElement()) {
            for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (!this.myBuilder.isOuterLanguageElement(child.getPsi())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<Block> splitComment() {
        if (this.myNode.getElementType() != XmlElementType.XML_COMMENT) {
            return EMPTY;
        }
        ArrayList<AbstractXmlBlock> result = new ArrayList<AbstractXmlBlock>(3);
        boolean hasOuterLangElements = false;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child instanceof OuterLanguageElement) {
                hasOuterLangElements = true;
            }
            if (this.myBuilder.isOuterLanguageElement(child.getPsi())) {
                result.add(this.createTemplateFragmentWrapper(child));
                continue;
            }
            result.add(new XmlBlock(child, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null, this.isPreserveSpace()));
        }
        return hasOuterLangElements ? result : EMPTY;
    }

    private AnotherLanguageBlockWrapper createTemplateFragmentWrapper(@NotNull ASTNode child) {
        return new AnotherLanguageBlockWrapper(child, this.myXmlFormattingPolicy, (Block)new ReadOnlyBlock(child), null, child.getStartOffset(), child.getTextRange());
    }
}

