/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagRenameDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(XmlTagRenameDialog.class);
    private final PsiElement myElement;
    private final Editor myEditor;
    private JLabel myTitleLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private final XmlTag myTag;
    private NameSuggestionsField.DataChanged myNameChangedListener;

    public XmlTagRenameDialog(@NotNull Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        super(element.getProject(), true);
        this.myEditor = editor;
        this.myElement = element;
        this.myTag = tag;
        this.setTitle(XmlTagRenameDialog.getRefactoringName());
        this.createNewNameComponent();
        this.init();
        this.myTitleLabel.setText(XmlBundle.message((String)"rename.current.tag", (Object[])new Object[]{XmlTagRenameDialog.getFullName(tag)}));
        this.validateButtons();
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean hasHelpAction() {
        return false;
    }

    private static String getFullName(@NotNull XmlTag tag) {
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)tag);
        return (UsageViewUtil.getType((PsiElement)tag) + " " + name).trim();
    }

    public static void renameXmlTag(Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        XmlTagRenameDialog dialog = new XmlTagRenameDialog(editor, element, tag);
        dialog.show();
    }

    private void createNewNameComponent() {
        this.myNameSuggestionsField = new NameSuggestionsField(new String[]{this.myTag.getName()}, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor);
        this.myNameChangedListener = () -> this.validateButtons();
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
        this.myNameSuggestionsField.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlTagRenameDialog.this.completeVariable(XmlTagRenameDialog.this.myNameSuggestionsField.getEditor());
            }
        }, KeyStroke.getKeyStroke(32, 2), 2);
    }

    private void completeVariable(Editor editor) {
        String prefix = this.myNameSuggestionsField.getEnteredName();
        PsiReference reference = this.myTag.getReference();
        if (reference instanceof TagNameReference) {
            LookupElement[] lookupItems = TagNameReferenceCompletionProvider.getTagNameVariants(this.myTag, this.myTag.getNamespacePrefix());
            editor.getCaretModel().moveToOffset(prefix.length());
            editor.getSelectionModel().removeSelection();
            LookupManager.getInstance((Project)this.getProject()).showLookup(editor, lookupItems, prefix);
        }
    }

    protected void doAction() {
        LOG.assertTrue(this.myElement.isValid());
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.myTag.setName(this.getNewName());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), RefactoringBundle.message((String)"rename.title"), null);
        this.close(0);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.myTitleLabel = new JLabel();
        panel.add(this.myTitleLabel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(this.myNameSuggestionsField.getComponent());
        return panel;
    }

    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    protected void validateButtons() {
        super.validateButtons();
        this.getPreviewAction().setEnabled(false);
    }

    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return !StringUtil.containsAnyChar((String)newName, (String)"\t ;*'\"\\/,()^&<>={}");
    }

    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"rename.title");
    }
}

