/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlTagInplaceRenamer {
    @NonNls
    private static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private final Editor myEditor;
    private static final Stack<XmlTagInplaceRenamer> ourRenamersStack = new Stack();
    private ArrayList<RangeHighlighter> myHighlighters;

    private XmlTagInplaceRenamer(@NotNull Editor editor) {
        this.myEditor = editor;
    }

    public static void rename(Editor editor, @NotNull XmlTag tag) {
        if (!ourRenamersStack.isEmpty()) {
            ((XmlTagInplaceRenamer)ourRenamersStack.peek()).finish();
        }
        XmlTagInplaceRenamer renamer = new XmlTagInplaceRenamer(editor);
        ourRenamersStack.push((Object)renamer);
        renamer.rename(tag);
    }

    private void rename(@NotNull XmlTag tag) {
        Pair<ASTNode, ASTNode> pair = this.getNamePair(tag);
        if (pair == null) {
            return;
        }
        Project project = this.myEditor.getProject();
        if (project != null) {
            ArrayList<TextRange> highlightRanges = new ArrayList<TextRange>();
            highlightRanges.add(((ASTNode)pair.first).getTextRange());
            if (pair.second != null) {
                highlightRanges.add(((ASTNode)pair.second).getTextRange());
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)tag)) {
                return;
            }
            this.myHighlighters = new ArrayList();
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                int offset = this.myEditor.getCaretModel().getOffset();
                this.myEditor.getCaretModel().moveToOffset(tag.getTextOffset());
                Template t = XmlTagInplaceRenamer.buildTemplate(tag, (Pair<? extends ASTNode, ? extends ASTNode>)pair);
                TemplateManager.getInstance((Project)project).startTemplate(this.myEditor, t, (TemplateEditingListener)new TemplateEditingAdapter(){

                    public void templateFinished(@NotNull Template template, boolean brokenOff) {
                        XmlTagInplaceRenamer.this.finish();
                    }

                    public void templateCancelled(Template template) {
                        XmlTagInplaceRenamer.this.finish();
                    }
                }, (variableName, value) -> value.length() == 0 || value.charAt(value.length() - 1) != ' ');
                this.myEditor.getCaretModel().moveToOffset(offset);
                XmlTagInplaceRenamer.addHighlights(highlightRanges, this.myEditor, this.myHighlighters);
            }), RefactoringBundle.message((String)"rename.title"), null);
        }
    }

    private void finish() {
        Project project;
        ourRenamersStack.pop();
        if (this.myHighlighters != null && (project = this.myEditor.getProject()) != null && !project.isDisposed()) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
            }
        }
    }

    private Pair<ASTNode, ASTNode> getNamePair(@NotNull XmlTag tag) {
        int offset = this.myEditor.getCaretModel().getOffset();
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        if (startTagName == null) {
            return null;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node);
        ASTNode selected = endTagName == null || startTagName.getTextRange().contains(offset) || startTagName.getTextRange().contains(offset - 1) ? startTagName : endTagName;
        ASTNode other = selected == startTagName ? endTagName : startTagName;
        return Pair.create((Object)selected, (Object)other);
    }

    private static Template buildTemplate(@NotNull XmlTag tag, @NotNull Pair<? extends ASTNode, ? extends ASTNode> pair) {
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)tag);
        ASTNode selected = (ASTNode)pair.first;
        ASTNode other = (ASTNode)pair.second;
        builder.replaceElement(selected.getPsi(), PRIMARY_VARIABLE_NAME, (Expression)new ConstantNode(selected.getText()), true);
        if (other != null) {
            builder.replaceElement(other.getPsi(), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
        return builder.buildInlineTemplate();
    }

    private static void addHighlights(List<? extends TextRange> ranges, Editor editor, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        for (TextRange textRange : ranges) {
            highlightManager.addOccurrenceHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter rangeHighlighter : highlighters) {
            rangeHighlighter.setGreedyToLeft(true);
            rangeHighlighter.setGreedyToRight(true);
        }
    }
}

