/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlArrangementVisitor;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import com.intellij.xml.arrangement.XmlRearranger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlRearranger
extends XmlRearranger {
    private static final List<StdArrangementMatchRule> DEFAULT_MATCH_RULES = new ArrayList<StdArrangementMatchRule>();
    private static final StdArrangementSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    @Override
    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    @Override
    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        return SETTINGS_SERIALIZER;
    }

    @Override
    @NotNull
    public List<XmlElementArrangementEntry> parse(@NotNull PsiElement root, final @Nullable Document document, final @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        XmlArrangementParseInfo parseInfo = new XmlArrangementParseInfo();
        root.accept((PsiElementVisitor)new XmlArrangementVisitor(parseInfo, ranges){

            @Override
            protected void postProcessTag(@NotNull XmlTag xmlTag, @NotNull XmlElementArrangementEntry xmlTagEntry) {
                HtmlRearranger.addEntriesForEmbeddedContent(xmlTag, xmlTagEntry, document, ranges);
            }
        });
        return parseInfo.getEntries();
    }

    private static void addEntriesForEmbeddedContent(@NotNull XmlTag xmlTag, @NotNull XmlElementArrangementEntry xmlTagEntry, @Nullable Document document, @NotNull Collection<TextRange> ranges) {
        if (!StringUtil.equals((CharSequence)xmlTag.getName(), (CharSequence)"script") && !StringUtil.equals((CharSequence)xmlTag.getName(), (CharSequence)"style")) {
            return;
        }
        for (XmlTagChild child : xmlTag.getValue().getChildren()) {
            List foreignEntries;
            Language childLanguage = child.getLanguage();
            if (childLanguage.isKindOf((Language)XMLLanguage.INSTANCE)) continue;
            Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(childLanguage);
            ArrangementSettings arrangementSettingsForLanguage = ArrangementUtil.getArrangementSettings((CodeStyleSettings)CodeStyle.getSettings((PsiFile)child.getContainingFile()), (Language)childLanguage);
            if (arrangementSettingsForLanguage == null || rearranger == null || (foreignEntries = rearranger.parse((PsiElement)child, document, ranges, arrangementSettingsForLanguage)).isEmpty()) continue;
            ForeignEntry foreignParent = new ForeignEntry((ArrangementEntry)xmlTagEntry, child.getTextRange());
            for (ArrangementEntry foreignEntry : foreignEntries) {
                foreignParent.addChild(foreignEntry);
            }
            xmlTagEntry.addChild((ArrangementEntry)foreignParent);
        }
    }

    static {
        StdArrangementMatchRule rule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE)), StdArrangementTokens.Order.BY_NAME);
        DEFAULT_MATCH_RULES.add(rule);
        DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(Collections.emptyList(), DEFAULT_MATCH_RULES);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);
    }

    private static class ForeignEntry
    extends XmlElementArrangementEntry {
        ForeignEntry(@Nullable ArrangementEntry parent, @NotNull TextRange range) {
            super(parent, range, StdArrangementTokens.EntryType.XML_TAG, null, null, false);
        }
    }
}

